/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.jdbc2.optional;

import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.Constants;
import com.gbase.jdbc.Util;
import com.gbase.jdbc.jdbc2.optional.GBasePooledConnection;
import com.gbase.jdbc.jdbc2.optional.GBaseXAException;
import com.gbase.jdbc.jdbc2.optional.GBaseXid;
import com.gbase.jdbc.log.Log;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class GBaseXAConnection
extends GBasePooledConnection
implements XAConnection,
XAResource {
    private ConnectionImpl underlyingConnection;
    private static final Map GBASE_ERROR_CODES_TO_XA_ERROR_CODES;
    private Log log;
    protected boolean logXaCommands;
    private static final Constructor JDBC_4_XA_CONNECTION_WRAPPER_CTOR;

    protected static GBaseXAConnection getInstance(ConnectionImpl gbaseConnection, boolean logXaCommands) throws SQLException {
        if (!Util.isJdbc4()) {
            return new GBaseXAConnection(gbaseConnection, logXaCommands);
        }
        return (GBaseXAConnection)Util.handleNewInstance(JDBC_4_XA_CONNECTION_WRAPPER_CTOR, new Object[]{gbaseConnection, logXaCommands}, gbaseConnection.getExceptionInterceptor());
    }

    public GBaseXAConnection(ConnectionImpl connection, boolean logXaCommands) throws SQLException {
        super(connection);
        this.underlyingConnection = connection;
        this.log = connection.getLog();
        this.logXaCommands = logXaCommands;
    }

    public XAResource getXAResource() throws SQLException {
        return this;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int arg0) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof GBaseXAConnection) {
            return this.underlyingConnection.isSameResource(((GBaseXAConnection)xares).underlyingConnection);
        }
        return false;
    }

    public Xid[] recover(int flag) throws XAException {
        return GBaseXAConnection.recover(this.underlyingConnection, flag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Xid[] recover(Connection c, int flag) throws XAException {
        ArrayList<GBaseXid> recoveredXidList;
        Statement stmt;
        block17: {
            boolean endRscan;
            boolean startRscan = (flag & 0x1000000) > 0;
            boolean bl = endRscan = (flag & 0x800000) > 0;
            if (!startRscan && !endRscan && flag != 0) {
                throw new GBaseXAException(-5, "Invalid flag, must use TMNOFLAGS, or any combination of TMSTARTRSCAN and TMENDRSCAN", null);
            }
            if (!startRscan) {
                return new Xid[0];
            }
            ResultSet rs = null;
            stmt = null;
            recoveredXidList = new ArrayList<GBaseXid>();
            try {
                try {
                    stmt = c.createStatement();
                    rs = stmt.executeQuery("XA RECOVER");
                    while (rs.next()) {
                        int formatId = rs.getInt(1);
                        int gtridLength = rs.getInt(2);
                        int bqualLength = rs.getInt(3);
                        byte[] gtridAndBqual = rs.getBytes(4);
                        byte[] gtrid = new byte[gtridLength];
                        byte[] bqual = new byte[bqualLength];
                        if (gtridAndBqual.length != gtridLength + bqualLength) {
                            throw new GBaseXAException(105, "Error while recovering XIDs from RM. GTRID and BQUAL are wrong sizes", null);
                        }
                        System.arraycopy(gtridAndBqual, 0, gtrid, 0, gtridLength);
                        System.arraycopy(gtridAndBqual, gtridLength, bqual, 0, bqualLength);
                        recoveredXidList.add(new GBaseXid(gtrid, bqual, formatId));
                    }
                    Object var14_17 = null;
                    if (rs == null) break block17;
                }
                catch (SQLException sqlEx) {
                    throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sqlEx) {
                        throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                    }
                }
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException sqlEx) {
                    throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
                }
            }
            try {}
            catch (SQLException sqlEx) {
                throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
            }
            rs.close();
        }
        if (stmt != null) {
            try {}
            catch (SQLException sqlEx) {
                throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
            }
            stmt.close();
        }
        int numXids = recoveredXidList.size();
        Xid[] asXids = new Xid[numXids];
        Object[] asObjects = recoveredXidList.toArray();
        int i = 0;
        while (i < numXids) {
            asXids[i] = (Xid)asObjects[i];
            ++i;
        }
        return asXids;
    }

    public int prepare(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA PREPARE ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        this.dispatchCommand(commandBuf.toString());
        return 0;
    }

    public void forget(Xid xid) throws XAException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA ROLLBACK ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        try {
            this.dispatchCommand(commandBuf.toString());
            Object var4_3 = null;
            this.underlyingConnection.setInGlobalTx(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.underlyingConnection.setInGlobalTx(false);
            throw throwable;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA END ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x2000000: {
                commandBuf.append(" SUSPEND");
                break;
            }
            case 0x20000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
    }

    public void start(Xid xid, int flags) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA START ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        switch (flags) {
            case 0x200000: {
                commandBuf.append(" JOIN");
                break;
            }
            case 0x8000000: {
                commandBuf.append(" RESUME");
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.dispatchCommand(commandBuf.toString());
        this.underlyingConnection.setInGlobalTx(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        StringBuffer commandBuf = new StringBuffer();
        commandBuf.append("XA COMMIT ");
        commandBuf.append(GBaseXAConnection.xidToString(xid));
        if (onePhase) {
            commandBuf.append(" ONE PHASE");
        }
        try {
            this.dispatchCommand(commandBuf.toString());
            Object var5_4 = null;
            this.underlyingConnection.setInGlobalTx(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.underlyingConnection.setInGlobalTx(false);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultSet dispatchCommand(String command) throws XAException {
        ResultSet resultSet;
        Statement stmt = null;
        try {
            try {
                ResultSet rs;
                if (this.logXaCommands) {
                    this.log.logDebug("Executing XA statement: " + command);
                }
                stmt = this.underlyingConnection.createStatement();
                stmt.execute(command);
                resultSet = rs = stmt.getResultSet();
                Object var6_6 = null;
                if (stmt == null) return resultSet;
            }
            catch (SQLException sqlEx) {
                throw GBaseXAConnection.mapXAExceptionFromSQLException(sqlEx);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            // empty catch block
            return resultSet;
        }
        stmt.close();
        return resultSet;
    }

    protected static XAException mapXAExceptionFromSQLException(SQLException sqlEx) {
        Integer xaCode = (Integer)GBASE_ERROR_CODES_TO_XA_ERROR_CODES.get(Constants.integerValueOf(sqlEx.getErrorCode()));
        if (xaCode != null) {
            return new GBaseXAException(xaCode, sqlEx.getMessage(), null);
        }
        return new GBaseXAException(sqlEx.getMessage(), null);
    }

    private static String xidToString(Xid xid) {
        String asHex;
        int i;
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] btrid = xid.getBranchQualifier();
        int lengthAsString = 6;
        if (gtrid != null) {
            lengthAsString += 2 * gtrid.length;
        }
        if (btrid != null) {
            lengthAsString += 2 * btrid.length;
        }
        String formatIdInHex = Integer.toHexString(xid.getFormatId());
        lengthAsString += formatIdInHex.length();
        StringBuffer asString = new StringBuffer(lengthAsString += 3);
        asString.append("0x");
        if (gtrid != null) {
            for (i = 0; i < gtrid.length; ++i) {
                asHex = Integer.toHexString(gtrid[i] & 0xFF);
                if (asHex.length() == 1) {
                    asString.append("0");
                }
                asString.append(asHex);
            }
        }
        asString.append(",");
        if (btrid != null) {
            asString.append("0x");
            for (i = 0; i < btrid.length; ++i) {
                asHex = Integer.toHexString(btrid[i] & 0xFF);
                if (asHex.length() == 1) {
                    asString.append("0");
                }
                asString.append(asHex);
            }
        }
        asString.append(",0x");
        asString.append(formatIdInHex);
        return asString.toString();
    }

    public synchronized Connection getConnection() throws SQLException {
        Connection connToWrap = this.getConnection(false, true);
        return connToWrap;
    }

    static {
        HashMap<Integer, Integer> temp = new HashMap<Integer, Integer>();
        temp.put(Constants.integerValueOf(1397), Constants.integerValueOf(-4));
        temp.put(Constants.integerValueOf(1398), Constants.integerValueOf(-5));
        temp.put(Constants.integerValueOf(1399), Constants.integerValueOf(-7));
        temp.put(Constants.integerValueOf(1400), Constants.integerValueOf(-9));
        temp.put(Constants.integerValueOf(1401), Constants.integerValueOf(-3));
        temp.put(Constants.integerValueOf(1402), Constants.integerValueOf(100));
        temp.put(1440, -8);
        GBASE_ERROR_CODES_TO_XA_ERROR_CODES = Collections.unmodifiableMap(temp);
        if (Util.isJdbc4()) {
            try {
                JDBC_4_XA_CONNECTION_WRAPPER_CTOR = Class.forName("com.gbase.jdbc.jdbc2.optional.JDBC4GBaseXAConnection").getConstructor(ConnectionImpl.class, Boolean.TYPE);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            JDBC_4_XA_CONNECTION_WRAPPER_CTOR = null;
        }
    }
}

