/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.spring;

import com.getui.push.v2.sdk.ApiHelper;
import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.common.ApiException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GtBeanFactory<T>
implements FactoryBean<T>,
InitializingBean {
    private ApiHelper apiHelper;
    private Class<T> apiClass;
    private T api;
    volatile boolean calledMethodAfterPropertiesSet = false;

    public GtBeanFactory(GtApiConfiguration configuration) {
        if (configuration == null) {
            throw new ApiException("configuration cannot be null.", true);
        }
        this.apiHelper = ApiHelper.build(configuration);
    }

    public T getObject() {
        if (this.api != null) {
            return this.api;
        }
        if (!this.calledMethodAfterPropertiesSet) {
            throw new ApiException("please call method afterPropertiesSet first.");
        }
        throw new ApiException("api is null, please check.");
    }

    public Class<?> getObjectType() {
        return this.apiClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() {
        if (this.apiHelper == null) {
            throw new ApiException("gtApiProxyFactory cannot be null.", true);
        }
        if (this.apiClass == null) {
            throw new ApiException("apiClass cannot be null.", true);
        }
        this.api = this.apiHelper.creatApi(this.apiClass);
        this.calledMethodAfterPropertiesSet = true;
    }

    public void setApiClass(Class<T> apiClass) {
        this.apiClass = apiClass;
    }
}

