/*
 * Decompiled with CFR 0.152.
 */
package com.linuxense.javadbf;

import com.linuxense.javadbf.DBFDataType;
import com.linuxense.javadbf.DBFUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class DBFField {
    @Deprecated
    public static final byte FIELD_TYPE_C = 67;
    @Deprecated
    public static final byte FIELD_TYPE_L = 76;
    @Deprecated
    public static final byte FIELD_TYPE_N = 78;
    @Deprecated
    public static final byte FIELD_TYPE_F = 70;
    @Deprecated
    public static final byte FIELD_TYPE_D = 68;
    @Deprecated
    public static final byte FIELD_TYPE_M = 77;
    private DBFDataType type;
    private int reserv1;
    private int length;
    private byte decimalCount;
    private short reserv2;
    private byte workAreaId;
    private short reserv3;
    private byte setFieldsFlag;
    private byte[] reserv4 = new byte[7];
    private byte indexFieldFlag;
    private String name;

    public DBFField() {
    }

    DBFField(DBFField origin) {
        this.type = origin.type;
        this.reserv1 = origin.reserv1;
        this.length = origin.length;
        this.decimalCount = origin.decimalCount;
        this.reserv2 = origin.reserv2;
        this.workAreaId = origin.workAreaId;
        this.reserv3 = origin.reserv3;
        this.setFieldsFlag = origin.setFieldsFlag;
        this.reserv4 = new byte[7];
        System.arraycopy(origin.reserv4, 0, this.reserv4, 0, 7);
        this.indexFieldFlag = origin.indexFieldFlag;
        this.name = origin.name;
    }

    public DBFField(String name, DBFDataType type) {
        this.setName(name);
        this.setType(type);
    }

    public DBFField(String name, DBFDataType type, int length) {
        this.setName(name);
        this.setType(type);
        this.setFieldLength(length);
    }

    public DBFField(String name, DBFDataType type, int length, int decimalCount) {
        this.setName(name);
        this.setType(type);
        this.setFieldLength(length);
        if (decimalCount != 0) {
            this.setDecimalCount(decimalCount);
        }
    }

    protected static DBFField createField(DataInput in, Charset charset, boolean useFieldFlags) throws IOException {
        DBFField field = new DBFField();
        byte t_byte = in.readByte();
        if (t_byte == 13) {
            return null;
        }
        byte[] fieldName = new byte[11];
        in.readFully(fieldName, 1, 10);
        fieldName[0] = t_byte;
        int nameNullIndex = fieldName.length - 1;
        for (int i = 0; i < fieldName.length; ++i) {
            if (fieldName[i] != 0) continue;
            nameNullIndex = i;
            break;
        }
        field.name = new String(fieldName, 0, nameNullIndex, charset);
        try {
            field.type = DBFDataType.fromCode(in.readByte());
        }
        catch (Exception e) {
            field.type = DBFDataType.UNKNOWN;
        }
        field.reserv1 = DBFUtils.readLittleEndianInt(in);
        field.length = in.readUnsignedByte();
        field.decimalCount = in.readByte();
        field.reserv2 = DBFUtils.readLittleEndianShort(in);
        field.workAreaId = in.readByte();
        field.reserv3 = DBFUtils.readLittleEndianShort(in);
        field.setFieldsFlag = in.readByte();
        in.readFully(field.reserv4);
        field.indexFieldFlag = in.readByte();
        DBFField.adjustLengthForLongCharSupport(field);
        if (!useFieldFlags) {
            field.reserv2 = 0;
        }
        return field;
    }

    protected static DBFField createFieldDB7(DataInput in, Charset charset) throws IOException {
        DBFField field = new DBFField();
        byte t_byte = in.readByte();
        if (t_byte == 13) {
            return null;
        }
        byte[] fieldName = new byte[32];
        in.readFully(fieldName, 1, 31);
        fieldName[0] = t_byte;
        int nameNullIndex = fieldName.length - 1;
        for (int i = 0; i < fieldName.length; ++i) {
            if (fieldName[i] != 0) continue;
            nameNullIndex = i;
            break;
        }
        field.name = new String(fieldName, 0, nameNullIndex, charset);
        try {
            field.type = DBFDataType.fromCode(in.readByte());
        }
        catch (Exception e) {
            field.type = DBFDataType.UNKNOWN;
        }
        field.length = in.readUnsignedByte();
        field.decimalCount = in.readByte();
        field.reserv2 = DBFUtils.readLittleEndianShort(in);
        field.workAreaId = in.readByte();
        field.reserv3 = DBFUtils.readLittleEndianShort(in);
        in.readInt();
        in.readInt();
        DBFField.adjustLengthForLongCharSupport(field);
        return field;
    }

    private static void adjustLengthForLongCharSupport(DBFField field) {
        if (field.type == DBFDataType.CHARACTER || field.type == DBFDataType.VARCHAR) {
            field.length |= field.decimalCount << 8;
            field.decimalCount = 0;
        }
    }

    protected void write(DataOutput out, Charset charset) throws IOException {
        out.write(this.name.getBytes(charset));
        out.write(new byte[11 - this.name.length()]);
        out.writeByte(this.type.getCode());
        out.writeInt(0);
        out.writeByte(this.length);
        out.writeByte(this.decimalCount);
        out.writeShort(0);
        out.writeByte(0);
        out.writeShort(0);
        out.writeByte(0);
        out.write(new byte[7]);
        out.writeByte(0);
    }

    public String getName() {
        return this.name;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        if (name.length() == 0 || name.length() > 10) {
            throw new IllegalArgumentException("Field name should be of length 0-10");
        }
        if (!DBFUtils.isPureAscii(name)) {
            throw new IllegalArgumentException("Field name must be ASCII");
        }
        this.name = name;
    }

    public int getReserv1() {
        return this.reserv1;
    }

    public short getReserv2() {
        return this.reserv2;
    }

    public byte getWorkAreaId() {
        return this.workAreaId;
    }

    public short getReserv3() {
        return this.reserv3;
    }

    public byte getSetFieldsFlag() {
        return this.setFieldsFlag;
    }

    public byte[] getReserv4() {
        return Arrays.copyOf(this.reserv4, this.reserv4.length);
    }

    public byte getIndexFieldFlag() {
        return this.indexFieldFlag;
    }

    public void setLength(int length) {
        if (length > this.type.getMaxSize() || length < this.type.getMinSize()) {
            throw new UnsupportedOperationException("Length for " + (Object)((Object)this.type) + " must be between " + this.type.getMinSize() + " and " + this.type.getMaxSize());
        }
        this.length = length;
    }

    public DBFDataType getType() {
        return this.type;
    }

    public void setType(DBFDataType type) {
        if (!type.isWriteSupported()) {
            throw new IllegalArgumentException("No support for writting " + (Object)((Object)type));
        }
        this.type = type;
        if (type.getDefaultSize() > 0) {
            this.length = type.getDefaultSize();
        }
    }

    public void setDecimalCount(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Decimal length should be a positive number");
        }
        if (size > this.length) {
            throw new IllegalArgumentException("Decimal length should be less than field length");
        }
        if (this.type != DBFDataType.NUMERIC && this.type != DBFDataType.FLOATING_POINT) {
            throw new UnsupportedOperationException("Cannot set decimal count on this field:" + (Object)((Object)this.type));
        }
        this.decimalCount = (byte)size;
    }

    public boolean isSystem() {
        return (this.reserv2 & 1) != 0;
    }

    public boolean isNullable() {
        return (this.reserv2 & 2) != 0;
    }

    public boolean isBinary() {
        return (this.reserv2 & 4) != 0;
    }

    public String toString() {
        return this.name + "|" + (Object)((Object)this.type) + " (" + this.type.getCharCode() + ")\nLength: " + this.length + "\nDecimalCount:" + this.decimalCount + "\nSystem:" + this.isSystem() + "\nNullable:" + this.isNullable() + "\nBinary:" + this.isBinary() + "\nIndex:" + this.indexFieldFlag;
    }

    @Deprecated
    public int getFieldLength() {
        return this.getLength();
    }

    @Deprecated
    public void setFieldLength(int length) {
        this.setLength(length);
    }

    @Deprecated
    public void setDataType(byte type) {
        this.setType(DBFDataType.fromCode(type));
    }

    @Deprecated
    public void setFieldName(String value) {
        this.setName(value);
    }

    @Deprecated
    public byte getDataType() {
        if (this.type != null) {
            return this.type.getCode();
        }
        return 0;
    }
}

