/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.utils.qrcode;

import com.github.binarywang.utils.qrcode.BufferedImageLuminanceSource;
import com.github.binarywang.utils.qrcode.MatrixToImageWriter;
import com.github.binarywang.utils.qrcode.MatrixToLogoImageConfig;
import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.EnumMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QrcodeUtils {
    private static final Logger log = LoggerFactory.getLogger(QrcodeUtils.class);
    private static final int DEFAULT_LENGTH = 400;
    private static final String FORMAT = "jpg";

    public static BitMatrix createQrcodeMatrix(String content, int length) {
        return QrcodeUtils.createQrcodeMatrix(content, length, ErrorCorrectionLevel.H);
    }

    public static BitMatrix createQrcodeMatrix(String content, int length, ErrorCorrectionLevel level) {
        EnumMap hints = Maps.newEnumMap(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        hints.put(EncodeHintType.ERROR_CORRECTION, level);
        try {
            return new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, length, length, (Map)hints);
        }
        catch (WriterException e) {
            throw new RuntimeException("\u5185\u5bb9\u4e3a\uff1a\u3010" + content + "\u3011\u7684\u4e8c\u7ef4\u7801\u751f\u6210\u5931\u8d25\uff01", e);
        }
    }

    public static byte[] createQrcode(String content, int length, File logoFile, MatrixToLogoImageConfig logoConfig) throws Exception {
        if (logoFile != null && !logoFile.exists()) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u6b63\u786e\u7684logo\u6587\u4ef6\uff01");
        }
        try (FileInputStream logo = logoFile == null ? null : new FileInputStream(logoFile);){
            byte[] byArray = QrcodeUtils.createQrcode(content, length, logo, logoConfig);
            return byArray;
        }
    }

    public static byte[] createQrcode(String content, int length, InputStream logo, MatrixToLogoImageConfig logoConfig) throws Exception {
        BufferedImage img = QrcodeUtils.generateQRCodeImage(content, length, logo, logoConfig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, FORMAT, baos);
        return baos.toByteArray();
    }

    public static byte[] createQrcode(String content, int length, File logoFile) throws Exception {
        return QrcodeUtils.createQrcode(content, length, logoFile, new MatrixToLogoImageConfig());
    }

    public static byte[] createQrcode(String content, File logoFile) throws Exception {
        return QrcodeUtils.createQrcode(content, 400, logoFile);
    }

    public static BufferedImage generateQRCodeImage(String content, int length, InputStream logo, MatrixToLogoImageConfig logoConfig) throws Exception {
        BitMatrix qrCodeMatrix = QrcodeUtils.createQrcodeMatrix(content, length);
        BufferedImage img = MatrixToImageWriter.toBufferedImage(qrCodeMatrix);
        try {
            if (logo != null) {
                QrcodeUtils.overlapImage(img, FORMAT, logo, logoConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e3a\u4e8c\u7ef4\u7801\u6dfb\u52a0LOGO\u65f6\u5931\u8d25\uff01", e);
        }
        return img;
    }

    public static BufferedImage generateQRCodeImage(String content, int length, File logoFile, MatrixToLogoImageConfig logoConfig) throws Exception {
        if (logoFile != null && !logoFile.exists()) {
            throw new IllegalArgumentException("\u8bf7\u63d0\u4f9b\u6b63\u786e\u7684logo\u6587\u4ef6\uff01");
        }
        try (InputStream logo = Files.newInputStream(logoFile.toPath(), new OpenOption[0]);){
            BufferedImage bufferedImage = QrcodeUtils.generateQRCodeImage(content, length, logo, logoConfig);
            return bufferedImage;
        }
    }

    public static BufferedImage generateQRCodeImage(String content, int length, InputStream logo) throws Exception {
        return QrcodeUtils.generateQRCodeImage(content, length, logo, new MatrixToLogoImageConfig());
    }

    public static BufferedImage generateQRCodeImage(String content, int length, File logoFile) throws Exception {
        return QrcodeUtils.generateQRCodeImage(content, length, logoFile, new MatrixToLogoImageConfig());
    }

    public static BufferedImage generateQRCodeImage(String content, InputStream logo) throws Exception {
        return QrcodeUtils.generateQRCodeImage(content, 400, logo);
    }

    public static BufferedImage generateQRCodeImage(String content, File logoFile) throws Exception {
        return QrcodeUtils.generateQRCodeImage(content, 400, logoFile);
    }

    private static void overlapImage(BufferedImage image, String ignoredFormat, InputStream logo, MatrixToLogoImageConfig logoConfig) throws IOException {
        BufferedImage logoImg = ImageIO.read(logo);
        logoImg = QrcodeUtils.clipRound(logoImg);
        Graphics2D g = logoImg.createGraphics();
        int width = image.getWidth() / logoConfig.getLogoPart();
        int height = image.getHeight() / logoConfig.getLogoPart();
        int radius = width / 10;
        int x = (image.getWidth() - width) / 2;
        int y = (image.getHeight() - height) / 2;
        BufferedImage buffer = g.getDeviceConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        g.dispose();
        g = buffer.createGraphics();
        g.setComposite(AlphaComposite.getInstance(12, 0.1f));
        g.setColor(Color.BLACK);
        g.fillRoundRect(x + 10, y + 10, width - 20, height, radius, radius);
        g.dispose();
        g = buffer.createGraphics();
        g.setComposite(AlphaComposite.getInstance(2, 1.0f));
        g.drawImage(logoImg, x, y, width, height, null);
        g.setStroke(new BasicStroke(logoConfig.getBorder()));
        g.setColor(logoConfig.getBorderColor());
        g.drawRoundRect(x, y, width, height, radius, radius);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(Color.GRAY);
        g.drawRoundRect(x + logoConfig.getBorder() / 2, y + logoConfig.getBorder() / 2, width - logoConfig.getBorder(), height - logoConfig.getBorder(), radius, radius);
        g.dispose();
        g = image.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, 1.0f));
        g.drawImage(buffer, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
    }

    private static BufferedImage clipRound(BufferedImage srcImage) {
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        int radius = width / 10;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setClip(new RoundRectangle2D.Double(0.0, 0.0, width, height, radius, radius));
        g.drawImage((Image)srcImage, 0, 0, null);
        g.dispose();
        return image;
    }

    public static String decodeQrcode(File file) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(file);
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        EnumMap hints = Maps.newEnumMap(DecodeHintType.class);
        hints.put(DecodeHintType.CHARACTER_SET, StandardCharsets.UTF_8.name());
        return new MultiFormatReader().decode(binaryBitmap, (Map)hints).getText();
    }

    private QrcodeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

