/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.HttpResponseProxy;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpMediaDownloadRequestExecutor
extends BaseMediaDownloadRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private static final Logger log = LoggerFactory.getLogger(OkHttpMediaDownloadRequestExecutor.class);

    public OkHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam, WxType wxType) throws WxErrorException, IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String contentType;
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        if ((contentType = (response = (client = (OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request = new Request.Builder().url(uri).get().build()).execute()).header("Content-Type")) != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.body().string(), wxType));
        }
        String fileName = new HttpResponseProxy(response).getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        String baseName = FilenameUtils.getBaseName((String)fileName);
        if (StringUtils.isBlank((CharSequence)fileName) || baseName.length() < 3) {
            baseName = String.valueOf(System.currentTimeMillis());
        }
        File file = File.createTempFile(baseName, "." + FilenameUtils.getExtension((String)fileName), this.tmpDirFile);
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)file));){
            sink.writeAll((Source)response.body().source());
        }
        file.deleteOnExit();
        return file;
    }
}

