/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.cp.bean.WxCpChat;

public class WxCpChatGsonAdapter
implements JsonSerializer<WxCpChat>,
JsonDeserializer<WxCpChat> {
    public JsonElement serialize(WxCpChat chat, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        if (chat.getId() != null) {
            json.addProperty("chatid", chat.getId());
        }
        if (chat.getName() != null) {
            json.addProperty("name", chat.getName());
        }
        if (chat.getOwner() != null) {
            json.addProperty("owner", chat.getOwner());
        }
        if (chat.getUsers() != null) {
            JsonArray users = new JsonArray();
            for (String user : chat.getUsers()) {
                users.add(user);
            }
            json.add("userlist", (JsonElement)users);
        }
        return json;
    }

    public WxCpChat deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject chatJson = json.getAsJsonObject();
        WxCpChat chat = new WxCpChat();
        chat.setId(GsonHelper.getAsString((JsonElement)chatJson.get("chatid")));
        chat.setName(GsonHelper.getAsString((JsonElement)chatJson.get("name")));
        chat.setOwner(GsonHelper.getAsString((JsonElement)chatJson.get("owner")));
        JsonArray usersJson = chatJson.getAsJsonArray("userlist");
        if (usersJson != null) {
            ArrayList<String> users = new ArrayList<String>(usersJson.size());
            chat.setUsers(users);
            for (JsonElement userJson : usersJson) {
                users.add(userJson.getAsString());
            }
        }
        return chat;
    }
}

