/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpMessageService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpLinkedCorpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessage;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendStatistics;
import me.chanjar.weixin.cp.bean.message.WxCpSchoolContactMessage;
import me.chanjar.weixin.cp.bean.message.WxCpSchoolContactMessageSendResult;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpMessageServiceImpl
implements WxCpMessageService {
    private final WxCpService cpService;

    @Override
    public WxCpMessageSendResult send(WxCpMessage message) throws WxErrorException {
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.cpService.getWxCpConfigStorage().getAgentId());
        }
        return WxCpMessageSendResult.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/message/send"), message.toJson()));
    }

    @Override
    public WxCpMessageSendStatistics getStatistics(int timeType) throws WxErrorException {
        return WxCpMessageSendStatistics.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/message/get_statistics"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"time_type", (Object)timeType))));
    }

    @Override
    public WxCpLinkedCorpMessageSendResult sendLinkedCorpMessage(WxCpLinkedCorpMessage message) throws WxErrorException {
        Integer agentId = message.getAgentId();
        if (null == agentId) {
            message.setAgentId(this.cpService.getWxCpConfigStorage().getAgentId());
        }
        return WxCpLinkedCorpMessageSendResult.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/linkedcorp/message/send"), message.toJson()));
    }

    @Override
    public WxCpSchoolContactMessageSendResult sendSchoolContactMessage(WxCpSchoolContactMessage message) throws WxErrorException {
        if (null == message.getAgentId()) {
            message.setAgentId(this.cpService.getWxCpConfigStorage().getAgentId());
        }
        return WxCpSchoolContactMessageSendResult.fromJson(this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/message/send"), message.toJson()));
    }

    @Override
    public void recall(String msgId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("msgid", msgId);
        String apiUrl = this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/message/recall");
        this.cpService.post(apiUrl, jsonObject.toString());
    }

    public WxCpMessageServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

