/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.cp.tp.service.WxCpTpOAuth2Service;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpOAuth2ServiceImpl
implements WxCpTpOAuth2Service {
    private final WxCpTpService mainService;

    @Override
    public String buildAuthorizeUrl(String redirectUri, String state) {
        return this.buildAuthorizeUrl(redirectUri, state, "snsapi_base");
    }

    @Override
    public String buildAuthorizeUrl(String redirectUri, String state, String scope) {
        StringBuilder url = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize");
        url.append("?appid=").append(this.mainService.getWxCpTpConfigStorage().getSuiteId());
        url.append("&redirect_uri=").append(URIUtil.encodeURIComponent((String)redirectUri));
        url.append("&response_type=code");
        url.append("&scope=").append(scope);
        if (state != null) {
            url.append("&state=").append(state);
        }
        url.append("#wechat_redirect");
        return url.toString();
    }

    public WxCpTpOAuth2ServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

