/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopAccountService;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopAccountUpdateInfoRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAccountGetBrandListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAccountGetCategoryListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAccountGetInfoResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopAccountServiceImpl
implements WxMaShopAccountService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopAccountServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private final WxMaService wxMaService;

    @Override
    public WxMaShopAccountGetCategoryListResponse getCategoryList() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/account/get_category_list", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAccountGetCategoryListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAccountGetCategoryListResponse.class);
    }

    @Override
    public WxMaShopAccountGetBrandListResponse getBrandList() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/account/get_brand_list", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAccountGetBrandListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAccountGetBrandListResponse.class);
    }

    @Override
    public WxMaShopBaseResponse updateInfo(WxMaShopAccountUpdateInfoRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/account/update_info", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopAccountGetInfoResponse getInfo() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/account/get_info", new JsonObject());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAccountGetInfoResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAccountGetInfoResponse.class);
    }

    public WxMaShopAccountServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

