/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.List;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpTemplateMsgService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplate;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateIndustry;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpTemplateMsgServiceImpl
implements WxMpTemplateMsgService {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private final WxMpService wxMpService;

    @Override
    public String sendTemplateMsg(WxMpTemplateMessage templateMessage) throws WxErrorException {
        String responseContent = this.wxMpService.post(WxMpApiUrl.TemplateMsg.MESSAGE_TEMPLATE_SEND, templateMessage.toJson());
        JsonObject jsonObject = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (jsonObject.get("errcode").getAsInt() == 0) {
            return jsonObject.get("msgid").getAsString();
        }
        throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MP));
    }

    @Override
    public boolean setIndustry(WxMpTemplateIndustry wxMpIndustry) throws WxErrorException {
        if (null == wxMpIndustry.getPrimaryIndustry() || null == wxMpIndustry.getPrimaryIndustry().getId() || null == wxMpIndustry.getSecondIndustry() || null == wxMpIndustry.getSecondIndustry().getId()) {
            throw new IllegalArgumentException("\u884c\u4e1aId\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e");
        }
        this.wxMpService.post(WxMpApiUrl.TemplateMsg.TEMPLATE_API_SET_INDUSTRY, wxMpIndustry.toJson());
        return true;
    }

    @Override
    public WxMpTemplateIndustry getIndustry() throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.TemplateMsg.TEMPLATE_GET_INDUSTRY, null);
        return WxMpTemplateIndustry.fromJson(responseContent);
    }

    @Override
    public String addTemplate(String shortTemplateId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("template_id_short", shortTemplateId);
        String responseContent = this.wxMpService.post(WxMpApiUrl.TemplateMsg.TEMPLATE_API_ADD_TEMPLATE, jsonObject.toString());
        JsonObject result = JSON_PARSER.parse(responseContent).getAsJsonObject();
        if (result.get("errcode").getAsInt() == 0) {
            return result.get("template_id").getAsString();
        }
        throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MP));
    }

    @Override
    public List<WxMpTemplate> getAllPrivateTemplate() throws WxErrorException {
        return WxMpTemplate.fromJson(this.wxMpService.get(WxMpApiUrl.TemplateMsg.TEMPLATE_GET_ALL_PRIVATE_TEMPLATE, null));
    }

    @Override
    public boolean delPrivateTemplate(String templateId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("template_id", templateId);
        String responseContent = this.wxMpService.post(WxMpApiUrl.TemplateMsg.TEMPLATE_DEL_PRIVATE_TEMPLATE, jsonObject.toString());
        WxError error = WxError.fromJson((String)responseContent, (WxType)WxType.MP);
        if (error.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(error);
    }

    public WxMpTemplateMsgServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

