/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.notify;

import com.github.binarywang.wxpay.bean.result.WxPayBaseResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.util.ToStringUtils;
import me.chanjar.weixin.common.util.xml.XStreamInitializer;
import org.apache.commons.codec.binary.Base64;

@XStreamAlias(value="xml")
public class WxPayRefundNotifyResult
extends WxPayBaseResult
implements Serializable {
    private static final long serialVersionUID = 4651725860079259186L;
    @XStreamAlias(value="req_info")
    private String reqInfoString;
    private ReqInfo reqInfo;

    public static WxPayRefundNotifyResult fromXML(String xmlString, String mchKey) throws WxPayException {
        WxPayRefundNotifyResult result = WxPayBaseResult.fromXML(xmlString, WxPayRefundNotifyResult.class);
        String reqInfoString = result.getReqInfoString();
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(mchKey.getBytes());
            String keyMd5String = new BigInteger(1, md5.digest()).toString(16).toLowerCase();
            SecretKeySpec key = new SecretKeySpec(keyMd5String.getBytes(), "AES");
            cipher.init(2, key);
            result.setReqInfo(ReqInfo.fromXML(new String(cipher.doFinal(Base64.decodeBase64((String)reqInfoString)))));
        }
        catch (Exception e) {
            throw new WxPayException("\u89e3\u5bc6\u9000\u6b3e\u901a\u77e5\u52a0\u5bc6\u4fe1\u606f\u65f6\u51fa\u9519", e);
        }
        return result;
    }

    public String getReqInfoString() {
        return this.reqInfoString;
    }

    public void setReqInfoString(String reqInfoString) {
        this.reqInfoString = reqInfoString;
    }

    public ReqInfo getReqInfo() {
        return this.reqInfo;
    }

    public void setReqInfo(ReqInfo reqInfo) {
        this.reqInfo = reqInfo;
    }

    @XStreamAlias(value="root")
    public static class ReqInfo {
        @XStreamAlias(value="transaction_id")
        private String transactionId;
        @XStreamAlias(value="out_trade_no")
        private String outTradeNo;
        @XStreamAlias(value="refund_id")
        private String refundId;
        @XStreamAlias(value="out_refund_no")
        private String outRefundNo;
        @XStreamAlias(value="total_fee")
        private Integer totalFee;
        @XStreamAlias(value="settlement_total_fee")
        private Integer settlementTotalFee;
        @XStreamAlias(value="refund_fee")
        private Integer refundFee;
        @XStreamAlias(value="settlement_refund_fee")
        private Integer settlementRefundFee;
        @XStreamAlias(value="refund_status")
        private String refundStatus;
        @XStreamAlias(value="success_time")
        private String successTime;
        @XStreamAlias(value="refund_recv_accout")
        private String refundRecvAccout;
        @XStreamAlias(value="refund_account")
        private String refundAccount;
        @XStreamAlias(value="refund_request_source")
        private String refundRequestSource;

        public String toString() {
            return ToStringUtils.toSimpleString((Object)this);
        }

        public String getTransactionId() {
            return this.transactionId;
        }

        public void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        public String getOutTradeNo() {
            return this.outTradeNo;
        }

        public void setOutTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
        }

        public String getRefundId() {
            return this.refundId;
        }

        public void setRefundId(String refundId) {
            this.refundId = refundId;
        }

        public String getOutRefundNo() {
            return this.outRefundNo;
        }

        public void setOutRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
        }

        public Integer getTotalFee() {
            return this.totalFee;
        }

        public void setTotalFee(Integer totalFee) {
            this.totalFee = totalFee;
        }

        public Integer getSettlementTotalFee() {
            return this.settlementTotalFee;
        }

        public void setSettlementTotalFee(Integer settlementTotalFee) {
            this.settlementTotalFee = settlementTotalFee;
        }

        public Integer getRefundFee() {
            return this.refundFee;
        }

        public void setRefundFee(Integer refundFee) {
            this.refundFee = refundFee;
        }

        public Integer getSettlementRefundFee() {
            return this.settlementRefundFee;
        }

        public void setSettlementRefundFee(Integer settlementRefundFee) {
            this.settlementRefundFee = settlementRefundFee;
        }

        public String getRefundStatus() {
            return this.refundStatus;
        }

        public void setRefundStatus(String refundStatus) {
            this.refundStatus = refundStatus;
        }

        public String getSuccessTime() {
            return this.successTime;
        }

        public void setSuccessTime(String successTime) {
            this.successTime = successTime;
        }

        public String getRefundRecvAccout() {
            return this.refundRecvAccout;
        }

        public void setRefundRecvAccout(String refundRecvAccout) {
            this.refundRecvAccout = refundRecvAccout;
        }

        public String getRefundAccount() {
            return this.refundAccount;
        }

        public void setRefundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
        }

        public String getRefundRequestSource() {
            return this.refundRequestSource;
        }

        public void setRefundRequestSource(String refundRequestSource) {
            this.refundRequestSource = refundRequestSource;
        }

        public static ReqInfo fromXML(String xmlString) {
            XStream xstream = XStreamInitializer.getInstance();
            xstream.processAnnotations(ReqInfo.class);
            return (ReqInfo)xstream.fromXML(xmlString);
        }
    }
}

