/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeConnectionPool;
import cn.beecp.BeeConnectionPoolMonitorVo;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.exception.ConnectionGetInterruptedException;
import cn.beecp.pool.exception.ConnectionGetTimeoutException;
import cn.beecp.pool.exception.PoolCreateFailedException;
import cn.beecp.pool.exception.PoolNotCreatedException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeeDataSource
extends BeeDataSourceConfig
implements DataSource,
XADataSource {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private long maxWaitNanos = TimeUnit.SECONDS.toNanos(8L);
    private BeeConnectionPool pool;
    private boolean ready;
    private SQLException cause;

    public BeeDataSource() {
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            BeeDataSource.createPool(this);
            this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createPool(BeeDataSource ds) throws SQLException {
        try {
            Class<?> poolClass = Class.forName(ds.getPoolImplementClassName());
            BeeConnectionPool pool = (BeeConnectionPool)PoolStaticCenter.createClassInstance(poolClass, BeeConnectionPool.class, "pool");
            pool.init(ds);
            ds.pool = pool;
            ds.ready = true;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PoolCreateFailedException("Failed to create connection pool by class:" + ds.getPoolImplementClassName(), e);
        }
    }

    @Override
    public final Connection getConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getConnection();
        }
        return this.createPoolByLock().getConnection();
    }

    @Override
    public final XAConnection getXAConnection() throws SQLException {
        if (this.ready) {
            return this.pool.getXAConnection();
        }
        return this.createPoolByLock().getXAConnection();
    }

    /*
     * Unable to fully structure code
     */
    private BeeConnectionPool createPoolByLock() throws SQLException {
        if (!this.lock.isWriteLocked() && this.lock.writeLock().tryLock()) {
            try {
                if (this.ready) ** GOTO lbl20
                this.cause = null;
                BeeDataSource.createPool(this);
            }
            catch (SQLException e) {
                this.cause = e;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        } else {
            try {
                if (!this.readLock.tryLock(this.maxWaitNanos, TimeUnit.NANOSECONDS)) {
                    throw new ConnectionGetTimeoutException("Connection get timeout at lock of pool creation");
                }
            }
            catch (InterruptedException e) {
                throw new ConnectionGetInterruptedException("Connection get request interrupted at lock of pool creation");
            }
            this.readLock.unlock();
        }
lbl20:
        // 4 sources

        if (this.cause != null) {
            throw this.cause;
        }
        return this.pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not support");
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not support");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz != null && clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz != null && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException("Wrapped object was not an instance of " + clazz);
    }

    public boolean isClosed() {
        return this.pool == null || this.pool.isClosed();
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (Throwable e) {
                PoolStaticCenter.CommonLog.error("Error at closing connection pool,cause:", e);
            }
        }
    }

    @Override
    public void setMaxWait(long maxWait) {
        if (maxWait > 0L) {
            super.setMaxWait(maxWait);
            this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(maxWait);
        }
    }

    @Override
    public void setPrintRuntimeLog(boolean printRuntimeLog) {
        if (this.pool != null) {
            this.pool.setPrintRuntimeLog(printRuntimeLog);
        }
    }

    public BeeConnectionPoolMonitorVo getPoolMonitorVo() throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreatedException("Connection pool not initialized");
        }
        return this.pool.getPoolMonitorVo();
    }

    public void clear(boolean forceCloseUsing) throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreatedException("Connection pool not initialized");
        }
        this.pool.clear(forceCloseUsing);
    }

    public void clear(boolean forceCloseUsing, BeeDataSourceConfig config) throws SQLException {
        if (this.pool == null) {
            throw new PoolNotCreatedException("Connection pool not initialized");
        }
        if (config == null) {
            throw new BeeDataSourceConfigException("Connection pool config can't be null");
        }
        this.pool.clear(forceCloseUsing, config);
        config.copyTo(this);
        this.maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(config.getMaxWait());
    }
}

