/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import redis.embedded.model.OsArchitecture;
import redis.embedded.util.IO;

public interface ExecutableProvider {
    public static final String ENVIRONMENT_EXECUTABLE_LOCATION = "EMBEDDED_REDIS_EXECUTABLE";
    public static final String PROPERTY_EXECUTABLE_LOCATION = "embedded.redis.executable";

    public File get() throws IOException;

    public static ExecutableProvider newEmbeddedRedis2_8_19Provider() {
        Map<OsArchitecture, String> executables = ExecutableProvider.newRedis2_8_19Map();
        return () -> IO.writeResourceToExecutableFile((String)executables.get(OsArchitecture.detectOSandArchitecture()));
    }

    public static ExecutableProvider newFileThenJarResourceProvider(Map<OsArchitecture, String> executables) {
        return () -> {
            String executablePath = (String)executables.get(OsArchitecture.detectOSandArchitecture());
            File executable = new File(executablePath);
            return executable.isFile() ? executable : IO.writeResourceToExecutableFile(executablePath);
        };
    }

    public static ExecutableProvider newEnvironmentVariableProvider() {
        return ExecutableProvider.newEnvironmentVariableProvider(ENVIRONMENT_EXECUTABLE_LOCATION);
    }

    public static ExecutableProvider newEnvironmentVariableProvider(String envName) {
        return () -> new File(System.getenv(envName));
    }

    public static ExecutableProvider newSystemPropertyProvider() {
        return ExecutableProvider.newSystemPropertyProvider(PROPERTY_EXECUTABLE_LOCATION);
    }

    public static ExecutableProvider newSystemPropertyProvider(String propertyName) {
        return () -> new File(System.getProperty(propertyName));
    }

    public static ExecutableProvider newJarResourceProvider(Map<OsArchitecture, String> executables) {
        return () -> IO.writeResourceToExecutableFile((String)executables.get(OsArchitecture.detectOSandArchitecture()));
    }

    public static ExecutableProvider newExecutableInPath(String executableName) throws FileNotFoundException {
        return IO.findBinaryInPath(executableName)::toFile;
    }

    public static Map<OsArchitecture, String> newRedis2_8_19Map() {
        HashMap<OsArchitecture, String> map = new HashMap<OsArchitecture, String>();
        map.put(OsArchitecture.WINDOWS_x86, "/redis-server-2.8.19.exe");
        map.put(OsArchitecture.WINDOWS_x86_64, "/redis-server-2.8.19.exe");
        map.put(OsArchitecture.UNIX_x86, "/redis-server-2.8.19-32");
        map.put(OsArchitecture.UNIX_x86_64, "/redis-server-2.8.19");
        map.put(OsArchitecture.UNIX_AARCH64, "/redis-server-2.8.19-linux-aarch64");
        map.put(OsArchitecture.MAC_OS_X_x86, "/redis-server-2.8.19.app");
        map.put(OsArchitecture.MAC_OS_X_x86_64, "/redis-server-2.8.19.app");
        return map;
    }
}

