/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.classmap.generator;

import com.github.dozermapper.core.classmap.ClassMap;
import com.github.dozermapper.core.classmap.ClassMapBuilder;
import com.github.dozermapper.core.classmap.Configuration;
import com.github.dozermapper.core.classmap.generator.GeneratorUtils;
import com.github.dozermapper.core.classmap.generator.JavaBeanFieldsDetector;
import com.github.dozermapper.core.classmap.generator.MappingType;
import com.github.dozermapper.core.classmap.generator.WildcardFieldMapping;
import com.github.dozermapper.core.config.BeanContainer;
import com.github.dozermapper.core.factory.DestBeanCreator;
import com.github.dozermapper.core.fieldmap.FieldMap;
import com.github.dozermapper.core.propertydescriptor.PropertyDescriptorFactory;
import com.github.dozermapper.core.util.CollectionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassLevelFieldMappingGenerator
implements ClassMapBuilder.ClassMappingGenerator {
    private final BeanContainer beanContainer;
    private final DestBeanCreator destBeanCreator;
    private final PropertyDescriptorFactory propertyDescriptorFactory;

    public ClassLevelFieldMappingGenerator(BeanContainer beanContainer, DestBeanCreator destBeanCreator, PropertyDescriptorFactory propertyDescriptorFactory) {
        this.beanContainer = beanContainer;
        this.destBeanCreator = destBeanCreator;
        this.propertyDescriptorFactory = propertyDescriptorFactory;
    }

    @Override
    public boolean accepts(ClassMap classMap) {
        return this.srcClassIsAccessible(classMap) || this.destClassIsAccessible(classMap);
    }

    @Override
    public boolean apply(ClassMap classMap, Configuration configuration) {
        JavaBeanFieldsDetector beanFieldsDetector = new JavaBeanFieldsDetector();
        Set<String> destFieldNames = this.getDeclaredFieldNames(classMap.getDestClassToMap());
        Set<String> destWritablePropertyNames = beanFieldsDetector.getWritableFieldNames(classMap.getDestClassToMap());
        Set<String> srcFieldNames = this.getDeclaredFieldNames(classMap.getSrcClassToMap());
        Set<String> srcReadablePropertyNames = beanFieldsDetector.getReadableFieldNames(classMap.getSrcClassToMap());
        Set<WildcardFieldMapping> matchingUnmappedFields = classMap.isWildcardCaseInsensitive() ? this.getMatchingUnmappedFieldNamesCaseInsensitive(classMap.getFieldMaps(), srcFieldNames, destFieldNames) : this.getMatchingUnmappedFieldNames(classMap.getFieldMaps(), srcFieldNames, destFieldNames);
        for (WildcardFieldMapping matchingFields : matchingUnmappedFields) {
            this.mapFieldAppropriately(classMap, configuration, matchingFields, destWritablePropertyNames, srcReadablePropertyNames);
        }
        return false;
    }

    private void mapFieldAppropriately(ClassMap classMap, Configuration configuration, WildcardFieldMapping matchingFields, Set<String> destWritablePropertyNames, Set<String> srcReadablePropertyNames) {
        MappingType mappingType = !this.destClassIsAccessible(classMap) && destWritablePropertyNames.contains(matchingFields.getSrcFieldName()) ? MappingType.FIELD_TO_SETTER : (!this.srcClassIsAccessible(classMap) && srcReadablePropertyNames.contains(matchingFields.getDestFieldName()) ? MappingType.GETTER_TO_FIELD : MappingType.FIELD_TO_FIELD);
        GeneratorUtils.addGenericMapping(mappingType, classMap, configuration, matchingFields.getSrcFieldName(), matchingFields.getDestFieldName(), this.beanContainer, this.destBeanCreator, this.propertyDescriptorFactory);
    }

    private Set<String> getDeclaredFieldNames(Class<?> srcType) {
        HashSet<String> declaredFieldNames = new HashSet<String>();
        do {
            for (Field field : srcType.getDeclaredFields()) {
                declaredFieldNames.add(field.getName());
            }
        } while ((srcType = srcType.getSuperclass()) != null);
        return declaredFieldNames;
    }

    private Set<WildcardFieldMapping> getMatchingUnmappedFieldNames(List<FieldMap> fieldMaps, Set<String> srcFieldNames, Set<String> destFieldNames) {
        for (FieldMap fieldMap : fieldMaps) {
            srcFieldNames.remove(fieldMap.getSrcFieldName());
            destFieldNames.remove(fieldMap.getDestFieldName());
        }
        return CollectionUtils.intersection(srcFieldNames, destFieldNames).stream().map(mutualFieldName -> new WildcardFieldMapping((String)mutualFieldName, (String)mutualFieldName)).collect(Collectors.toSet());
    }

    private Set<WildcardFieldMapping> getMatchingUnmappedFieldNamesCaseInsensitive(List<FieldMap> fieldMaps, Set<String> srcFieldNames, Set<String> destFieldNames) {
        HashMap<String, String> srcFieldNamesLookup = new HashMap<String, String>(srcFieldNames.size(), 1.0f);
        HashMap<String, String> destFieldNamesLookup = new HashMap<String, String>(destFieldNames.size(), 1.0f);
        for (String srcFieldName : srcFieldNames) {
            srcFieldNamesLookup.put(srcFieldName.toLowerCase(), srcFieldName);
        }
        for (String destFieldName : destFieldNames) {
            destFieldNamesLookup.put(destFieldName.toLowerCase(), destFieldName);
        }
        for (FieldMap fieldMap : fieldMaps) {
            srcFieldNamesLookup.remove(fieldMap.getSrcFieldName().toLowerCase());
            destFieldNamesLookup.remove(fieldMap.getDestFieldName().toLowerCase());
        }
        HashSet<WildcardFieldMapping> wildcardFields = new HashSet<WildcardFieldMapping>();
        for (Map.Entry lowercaseToActualFieldName : srcFieldNamesLookup.entrySet()) {
            if (!destFieldNamesLookup.containsKey(lowercaseToActualFieldName.getKey())) continue;
            wildcardFields.add(new WildcardFieldMapping((String)lowercaseToActualFieldName.getValue(), (String)destFieldNamesLookup.get(lowercaseToActualFieldName.getKey())));
        }
        return wildcardFields;
    }

    private boolean destClassIsAccessible(ClassMap classMap) {
        return classMap.getDestClass() != null && classMap.getDestClass().isAccessible();
    }

    private boolean srcClassIsAccessible(ClassMap classMap) {
        return classMap.getSrcClass() != null && classMap.getSrcClass().isAccessible();
    }
}

