/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.dreamhead.moco.dumper.HttpProtocolVersionDeserializer;
import com.github.dreamhead.moco.dumper.HttpProtocolVersionSerializer;

@JsonSerialize(using=HttpProtocolVersionSerializer.class)
@JsonDeserialize(using=HttpProtocolVersionDeserializer.class)
public enum HttpProtocolVersion {
    VERSION_0_9("HTTP/0.9"),
    VERSION_1_0("HTTP/1.0"),
    VERSION_1_1("HTTP/1.1");

    private final String text;

    private HttpProtocolVersion(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public String toString() {
        return this.text;
    }

    public static HttpProtocolVersion versionOf(String version) {
        HttpProtocolVersion[] values;
        for (HttpProtocolVersion value : values = HttpProtocolVersion.values()) {
            if (!value.text.equalsIgnoreCase(version)) continue;
            return value;
        }
        throw new IllegalArgumentException("unknown HTTP version: " + version);
    }
}

