/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.dumper;

import com.github.dreamhead.moco.HttpMessage;
import com.github.dreamhead.moco.model.MessageContent;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import io.netty.util.internal.StringUtil;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class HttpDumpers {
    private static final Joiner.MapJoiner HEAD_JOINER = Joiner.on((String)StringUtil.NEWLINE).withKeyValueSeparator(": ");

    public static String asContent(HttpMessage message) {
        if (HttpDumpers.hasContent(message)) {
            return StringUtil.NEWLINE + StringUtil.NEWLINE + HttpDumpers.contentForDump(message);
        }
        return "";
    }

    private static String contentForDump(HttpMessage message) {
        String type = message.getHeader("Content-Type");
        if (HttpDumpers.isText(type)) {
            return message.getContent().toString();
        }
        return "<content is binary>";
    }

    private static boolean isText(String type) {
        try {
            MediaType mediaType = MediaType.parse((String)type);
            return mediaType.is(MediaType.ANY_TEXT_TYPE) || mediaType.subtype().endsWith("javascript") || mediaType.subtype().endsWith("json") || mediaType.subtype().endsWith("xml") || mediaType.is(MediaType.FORM_DATA) || mediaType.subtype().endsWith("form-data");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean hasContent(HttpMessage message) {
        String lengthText = message.getHeader("Content-Length");
        if (lengthText != null) {
            return true;
        }
        MessageContent content = message.getContent();
        return content != null && content.hasContent();
    }

    public static String asHeaders(HttpMessage message) {
        return HEAD_JOINER.join((Iterable)message.getHeaders().entrySet().stream().flatMap(HttpDumpers::toEntries).collect(Collectors.toList()));
    }

    private static Stream<Map.Entry<String, String>> toEntries(Map.Entry<String, String[]> input) {
        String key = input.getKey();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : input.getValue()) {
            builder.add((Object)Maps.immutableEntry((Object)key, (Object)value));
        }
        return builder.build().stream();
    }

    private HttpDumpers() {
    }
}

