/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractProxyResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;

public class ProxyResponseHandler
extends AbstractProxyResponseHandler
implements ResponseHandler {
    private final Function<HttpRequest, URL> url;

    public ProxyResponseHandler(Function<HttpRequest, URL> url, Failover failover) {
        super(failover);
        this.url = url;
    }

    @Override
    protected final Optional<String> doRemoteUrl(HttpRequest request) {
        try {
            URL targetUrl = this.url.apply(request);
            if (targetUrl != null) {
                return Optional.of(targetUrl.toString());
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

