/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler.proxy;

import com.github.dreamhead.moco.util.Preconditions;
import com.github.dreamhead.moco.util.URLs;
import com.google.common.base.Strings;

public final class ProxyConfig {
    private final String localBase;
    private final String remoteBase;

    private ProxyConfig(String localBase, String remoteBase) {
        this.localBase = localBase;
        this.remoteBase = remoteBase;
    }

    public String localBase() {
        return this.localBase;
    }

    public String remoteBase() {
        return this.remoteBase;
    }

    public boolean canAccessedBy(String uri) {
        return uri.startsWith(this.localBase);
    }

    public String remoteUrl(String uri) {
        String relative = Strings.nullToEmpty((String)uri.replaceFirst(this.localBase, ""));
        return URLs.join(this.remoteBase, relative);
    }

    public static Builder builder(String localBase) {
        return new Builder(localBase);
    }

    public static final class Builder {
        private final String localBase;

        public Builder(String localBase) {
            this.localBase = localBase;
        }

        public ProxyConfig to(String remoteBase) {
            return new ProxyConfig(URLs.toBase(this.localBase), URLs.toBase(Preconditions.checkNotNullOrEmpty(remoteBase, "Remote base should not be null")));
        }
    }
}

