/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.HttpHandler;
import com.github.dreamhead.moco.internal.WebSocketHandler;
import com.github.dreamhead.moco.util.Strings;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public final class MocoHandler
extends SimpleChannelInboundHandler<Object> {
    private final ActualHttpServer server;
    private final HttpHandler httpHandler;
    private final WebSocketHandler websocketHandler;

    public MocoHandler(ActualHttpServer server) {
        this.server = server;
        this.httpHandler = new HttpHandler(server);
        this.websocketHandler = new WebSocketHandler(server.getWebsocketServer());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.websocketHandler.disconnect(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object message) {
        if (message instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)message);
            return;
        }
        if (message instanceof WebSocketFrame) {
            this.websocketHandler.handleFrame(ctx, (WebSocketFrame)message);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (!request.decoderResult().isSuccess()) {
            ctx.writeAndFlush((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
            return;
        }
        if (!this.upgradeWebsocket(request)) {
            FullHttpResponse response = this.httpHandler.handleRequest(request);
            this.closeIfNotKeepAlive(request, ctx.write((Object)response));
            return;
        }
        this.websocketHandler.connect(ctx, request);
    }

    private boolean upgradeWebsocket(FullHttpRequest request) {
        if (HttpMethod.GET.equals((Object)request.method())) {
            String upgrade = request.headers().get("Upgrade");
            return "websocket".equals(Strings.strip(upgrade));
        }
        return false;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void closeIfNotKeepAlive(FullHttpRequest request, ChannelFuture future) {
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.server.onException(cause);
    }
}

