/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.ResponseSetting;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.internal.SettingFetcher;
import com.github.dreamhead.moco.setting.Setting;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public class Responser<T extends ResponseSetting<T>> {
    private final SettingFetcher<T> fetcher;

    public Responser(SettingFetcher<T> fetcher) {
        this.fetcher = fetcher;
    }

    public Optional<Response> getResponse(SessionContext context) {
        Request request = context.getRequest();
        ImmutableList<Setting<T>> settings = this.fetcher.getSettings();
        for (Setting setting : settings) {
            if (!setting.match(request)) continue;
            setting.writeToResponse(context);
            return Optional.of(context.getResponse());
        }
        Setting<T> anySetting = this.fetcher.getAnySetting();
        if (anySetting.match(request)) {
            anySetting.writeToResponse(context);
            return Optional.of(context.getResponse());
        }
        return Optional.empty();
    }
}

