/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.util.ByteBufs;
import com.github.dreamhead.moco.websocket.ActualWebSocketServer;
import com.github.dreamhead.moco.websocket.WebsocketResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.Optional;

public class WebSocketHandler {
    private final ActualWebSocketServer websocketServer;

    public WebSocketHandler(ActualWebSocketServer websocketServer) {
        this.websocketServer = websocketServer;
    }

    public void handleFrame(ChannelHandlerContext ctx, WebSocketFrame message) {
        if (this.websocketServer == null) {
            return;
        }
        Optional<WebSocketFrame> frame = this.getResponseFrame(ctx, message);
        frame.ifPresent(webSocketFrame -> ctx.channel().writeAndFlush(webSocketFrame));
    }

    private Optional<WebSocketFrame> getResponseFrame(ChannelHandlerContext ctx, WebSocketFrame message) {
        if (message instanceof PingWebSocketFrame) {
            return Optional.of(this.websocketServer.handlePingPong((PingWebSocketFrame)message));
        }
        Optional<WebsocketResponse> response = this.websocketServer.handleRequest(ctx, message);
        if (response.isPresent()) {
            ByteBuf byteBuf = ByteBufs.toByteBuf(response.get().getContent().getContent());
            return Optional.of(new BinaryWebSocketFrame(byteBuf));
        }
        return Optional.empty();
    }

    public final void connect(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (this.websocketServer != null) {
            this.websocketServer.connectRequest(ctx, request);
        }
    }

    public final void disconnect(ChannelHandlerContext ctx) {
        if (this.websocketServer != null) {
            this.websocketServer.disconnect(ctx.channel());
        }
    }
}

