/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.Response;
import com.github.dreamhead.moco.util.Locks;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ThreadSafeMonitor
implements MocoMonitor {
    private final MocoMonitor monitor;
    private final Lock lock = new ReentrantLock();

    public ThreadSafeMonitor(MocoMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void onMessageArrived(Request request) {
        Locks.withLock(this.lock, () -> this.monitor.onMessageArrived(request));
    }

    @Override
    public void onException(Throwable t) {
        Locks.withLock(this.lock, () -> this.monitor.onException(t));
    }

    @Override
    public void onMessageLeave(Response response) {
        Locks.withLock(this.lock, () -> this.monitor.onMessageLeave(response));
    }

    @Override
    public void onUnexpectedMessage(Request request) {
        Locks.withLock(this.lock, () -> this.monitor.onUnexpectedMessage(request));
    }
}

