/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.mount;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.mount.AbstractHttpContentResponseHandler;
import com.github.dreamhead.moco.mount.MountPathExtractor;
import com.github.dreamhead.moco.mount.MountTo;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.FileResourceReader;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.net.MediaType;
import java.io.File;
import java.util.Optional;

public final class MountHandler
extends AbstractHttpContentResponseHandler {
    private final MountPathExtractor extractor;
    private final File dir;
    private final MountTo target;

    public MountHandler(File dir, MountTo target) {
        this.dir = dir;
        this.target = target;
        this.extractor = new MountPathExtractor(target);
    }

    @Override
    protected MessageContent responseContent(HttpRequest httpRequest) {
        FileResourceReader reader = new FileResourceReader(this.asResource(httpRequest));
        return reader.readFor(httpRequest);
    }

    private Resource asResource(HttpRequest httpRequest) {
        return Moco.text(this.targetFile(httpRequest).getPath());
    }

    private File targetFile(HttpRequest request) {
        Optional relativePath = this.extractor.extract(request);
        if (!relativePath.isPresent()) {
            throw new IllegalStateException("Reach mount handler without relative path");
        }
        return new File(this.dir, (String)relativePath.get());
    }

    @Override
    protected MediaType getContentType(HttpRequest request) {
        return new FileContentType(this.targetFile(request).getName()).getContentType();
    }

    @Override
    public ResponseHandler doApply(MocoConfig config) {
        if (config.isFor("uri")) {
            return new MountHandler(this.dir, this.target.apply(config));
        }
        if (config.isFor("file")) {
            return new MountHandler(new File(config.apply(this.dir.getName())), this.target);
        }
        return this;
    }
}

