/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.recorder.TapeContent;
import com.github.dreamhead.moco.util.Jsons;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RecorderTape
implements RecorderConfig {
    private final Path path;

    public RecorderTape(String path) {
        this.path = Paths.get(path, new String[0]);
    }

    public final void write(String name, HttpRequest httpRequest) {
        TapeContent content = this.getTapeContent();
        content.addRequest(name, httpRequest);
        Jsons.writeToFile(this.path, (Object)content);
    }

    private TapeContent getTapeContent() {
        try {
            BufferedReader reader = Files.newBufferedReader(this.path);
            if (reader.ready()) {
                return Jsons.toObject(reader, TapeContent.class);
            }
            return new TapeContent();
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return new TapeContent();
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    public final HttpRequest read(String name) {
        return this.getTapeContent().getRequest(name);
    }

    @Override
    public final boolean isFor(String name) {
        return "tape".equalsIgnoreCase(name);
    }
}

