/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.IdFactory;
import com.github.dreamhead.moco.resource.Identifiable;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceConfigApplier;
import com.github.dreamhead.moco.resource.ResourceConfigApplierFactory;
import com.github.dreamhead.moco.resource.ResourceReader;
import com.github.dreamhead.moco.resource.reader.ClasspathFileResourceReader;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.resource.reader.FileResourceReader;
import com.github.dreamhead.moco.resource.reader.JsonResourceReader;
import com.github.dreamhead.moco.resource.reader.TemplateResourceReader;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.github.dreamhead.moco.util.Cookies;
import com.github.dreamhead.moco.util.FileContentType;
import com.github.dreamhead.moco.util.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Function;

public final class ResourceFactory {
    public static ContentResource textResource(final Function<Request, String> function) {
        return ResourceFactory.contentResource(IdFactory.id("text"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ContentResourceReader(){

            @Override
            public MediaType getContentType(HttpRequest request) {
                return FileContentType.DEFAULT_CONTENT_TYPE_WITH_CHARSET;
            }

            @Override
            public MessageContent readFor(Request request) {
                return MessageContent.content((String)Functions.checkApply(function, request));
            }
        });
    }

    public static ContentResource binaryResource(final Function<Request, Object> function) {
        return ResourceFactory.contentResource(IdFactory.id("binary"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ContentResourceReader(){

            @Override
            public MediaType getContentType(HttpRequest request) {
                return MediaType.APPLICATION_BINARY;
            }

            @Override
            public MessageContent readFor(Request request) {
                Object result = Functions.checkApply(function, request);
                if (result instanceof byte[]) {
                    return MessageContent.content().withContent((byte[])result).build();
                }
                if (result instanceof ByteBuffer) {
                    ByteBuffer buffer = (ByteBuffer)result;
                    return MessageContent.content().withContent(buffer).build();
                }
                if (result instanceof InputStream) {
                    InputStream is = (InputStream)result;
                    return MessageContent.content().withContent(is).build();
                }
                if (result instanceof String) {
                    String text = (String)result;
                    return MessageContent.content().withContent(text).build();
                }
                throw new IllegalArgumentException("Not allowed " + result.getClass());
            }
        });
    }

    public static ContentResource fileResource(Resource filename, Charset charset, MocoConfig config) {
        return ResourceFactory.contentResource(IdFactory.id("file"), ResourceConfigApplierFactory.fileConfigApplier("file", filename), new FileResourceReader(filename, charset, config));
    }

    public static ContentResource classpathFileResource(Resource filename, Charset charset) {
        return ResourceFactory.contentResource(IdFactory.id("pathresource"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ClasspathFileResourceReader(filename, charset));
    }

    public static ContentResource jsonResource(Function<Request, Object> function) {
        return ResourceFactory.contentResource(IdFactory.id("json"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new JsonResourceReader(function));
    }

    public static Resource methodResource(String method) {
        return ResourceFactory.resource(IdFactory.id("method"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, request -> MessageContent.content(method.toUpperCase()));
    }

    public static Resource versionResource(Resource version) {
        return ResourceFactory.resource(IdFactory.id("version"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, request -> {
            String text = HttpProtocolVersion.versionOf(version.readFor(request).toString()).text();
            return MessageContent.content(text);
        });
    }

    public static Resource versionResource(HttpProtocolVersion version) {
        return ResourceFactory.resource(IdFactory.id("version"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, request -> MessageContent.content(version.text()));
    }

    public static Resource cookieResource(String key, Resource resource, CookieAttribute ... options) {
        return ResourceFactory.resource(IdFactory.id("cookie"), ResourceConfigApplierFactory.cookieConfigApplier(key, resource), request -> {
            MessageContent messageContent = resource.readFor(request);
            return MessageContent.content(new Cookies().encodeCookie(key, messageContent.toString(), options));
        });
    }

    public static ContentResource templateResource(ContentResource template, ImmutableMap<String, ? extends Variable> variables) {
        return ResourceFactory.contentResource(IdFactory.id("template"), ResourceConfigApplierFactory.templateConfigApplier(template, variables), new TemplateResourceReader(template, variables));
    }

    public static Resource uriResource(String uri) {
        return ResourceFactory.resource(IdFactory.id("uri"), ResourceConfigApplierFactory.uriConfigApplier("uri", uri), request -> MessageContent.content(uri));
    }

    private static ContentResource contentResource(Identifiable id, ResourceConfigApplier applier, ContentResourceReader reader) {
        return new ContentResource(id, applier, reader);
    }

    private static Resource resource(Identifiable id, ResourceConfigApplier applier, ResourceReader reader) {
        return new Resource(id, applier, reader);
    }

    private ResourceFactory() {
    }
}

