/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.google.common.net.MediaType;
import java.util.function.Function;

public class TransformResourceReader
implements ContentResourceReader {
    private final Function<byte[], byte[]> transformer;
    private final ContentResourceReader reader;

    public TransformResourceReader(Function<byte[], byte[]> transformer, ContentResourceReader reader) {
        this.transformer = transformer;
        this.reader = reader;
    }

    @Override
    public MessageContent readFor(Request request) {
        MessageContent messageContent = this.reader.readFor(request);
        byte[] transformed = this.transformer.apply(messageContent.getContent());
        return MessageContent.content().withCharset(messageContent.getCharset()).withContent(transformed).build();
    }

    @Override
    public MediaType getContentType(HttpRequest request) {
        return this.reader.getContentType(request);
    }
}

