/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.rest.SimpleRestSetting;
import java.util.Optional;

public final class CompositeRestSetting<T extends SimpleRestSetting>
implements RestSetting {
    private final Iterable<T> settings;

    public CompositeRestSetting(Iterable<T> settings) {
        this.settings = settings;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public Optional<ResponseHandler> getMatched(RestIdMatcher resourceName, HttpRequest httpRequest) {
        for (RestSetting setting : this.settings) {
            Optional<ResponseHandler> responseHandler = setting.getMatched(resourceName, httpRequest);
            if (!responseHandler.isPresent()) continue;
            return responseHandler;
        }
        return Optional.empty();
    }

    public Iterable<T> getSettings() {
        return this.settings;
    }
}

