/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.handler.JsonResponseHandler;
import com.github.dreamhead.moco.rest.CompositeRestSetting;
import com.github.dreamhead.moco.rest.RestAllSetting;
import com.github.dreamhead.moco.rest.RestIdMatchers;
import com.github.dreamhead.moco.rest.RestSingleSetting;
import com.github.dreamhead.moco.rest.SimpleRestSetting;
import com.github.dreamhead.moco.rest.SubResourceSetting;
import com.github.dreamhead.moco.util.URLs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class RestRequestDispatcher {
    private static final ResponseHandler NOT_FOUND_HANDLER = Moco.status(HttpResponseStatus.NOT_FOUND.code());
    private static final ResponseHandler BAD_REQUEST_HANDLER = Moco.status(HttpResponseStatus.BAD_REQUEST.code());
    private final RestIdMatcher name;
    private final RequestMatcher allMatcher;
    private final RequestMatcher singleMatcher;
    private final CompositeRestSetting<RestAllSetting> getAllSettings;
    private final CompositeRestSetting<RestSingleSetting> getSingleSettings;
    private final CompositeRestSetting<RestAllSetting> postSettings;
    private final CompositeRestSetting<RestSingleSetting> putSettings;
    private final CompositeRestSetting<RestSingleSetting> deleteSettings;
    private final CompositeRestSetting<RestSingleSetting> headSettings;
    private final CompositeRestSetting<RestAllSetting> headAllSettings;
    private final CompositeRestSetting<RestSingleSetting> patchSettings;
    private final Iterable<SubResourceSetting> subResourceSettings;

    public RestRequestDispatcher(String name, Iterable<RestSetting> settings) {
        this.name = RestIdMatchers.eq(name);
        this.getAllSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.GET);
        this.getSingleSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.GET);
        this.postSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.POST);
        this.putSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.PUT);
        this.deleteSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.DELETE);
        this.headSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.HEAD);
        this.headAllSettings = this.filterSettings(settings, RestAllSetting.class, HttpMethod.HEAD);
        this.patchSettings = this.filterSettings(settings, RestSingleSetting.class, HttpMethod.PATCH);
        this.subResourceSettings = this.filter(settings, SubResourceSetting.class);
        this.allMatcher = Moco.by(Moco.uri(URLs.resourceRoot(name)));
        this.singleMatcher = Moco.match(Moco.uri(URLs.join(URLs.resourceRoot(name), "[^/]*")));
    }

    private <T extends SimpleRestSetting> CompositeRestSetting<T> filterSettings(Iterable<RestSetting> settings, Class<T> type, HttpMethod method) {
        return new CompositeRestSetting<T>(this.filter(settings, type, method));
    }

    private <T extends SimpleRestSetting> Iterable<T> filter(Iterable<RestSetting> settings, Class<T> type, HttpMethod method) {
        return this.filter(settings, type).stream().filter(input -> input.isSimple() && input.isFor(method)).collect(Collectors.toList());
    }

    private <T extends RestSetting> ImmutableList<T> filter(Iterable<RestSetting> settings, Class<T> type) {
        return (ImmutableList)StreamSupport.stream(settings.spliterator(), false).filter(type::isInstance).map(type::cast).collect(ImmutableList.toImmutableList());
    }

    private Optional<ResponseHandler> getSingleOrAllHandler(HttpRequest httpRequest, CompositeRestSetting<RestSingleSetting> single, CompositeRestSetting<RestAllSetting> all, RestIdMatcher name) {
        Optional<ResponseHandler> singleHandler = single.getMatched(name, httpRequest);
        if (singleHandler.isPresent()) {
            return singleHandler;
        }
        return all.getMatched(name, httpRequest);
    }

    private Optional<ResponseHandler> getHeadHandler(HttpRequest httpRequest) {
        Optional<ResponseHandler> handler = this.getSingleOrAllHandler(httpRequest, this.headSettings, this.headAllSettings, this.name);
        if (handler.isPresent()) {
            return handler;
        }
        return Optional.of(NOT_FOUND_HANDLER);
    }

    private Optional<ResponseHandler> getGetHandler(HttpRequest httpRequest) {
        Iterable<RestSingleSetting> settings;
        Optional<ResponseHandler> matchedSetting = this.getSingleOrAllHandler(httpRequest, this.getSingleSettings, this.getAllSettings, this.name);
        if (matchedSetting.isPresent()) {
            return matchedSetting;
        }
        if (this.allMatcher.match(httpRequest) && !Iterables.isEmpty(settings = this.getSingleSettings.getSettings()) && StreamSupport.stream(settings.spliterator(), false).allMatch(setting -> setting.getHandler() instanceof JsonResponseHandler)) {
            List result = StreamSupport.stream(settings.spliterator(), false).map(setting -> (JsonResponseHandler)JsonResponseHandler.class.cast(setting.getHandler())).map(JsonResponseHandler::getPojo).collect(Collectors.toList());
            return Optional.of(Moco.with(Moco.json(result)));
        }
        return Optional.of(NOT_FOUND_HANDLER);
    }

    private Optional<ResponseHandler> getPostHandler(HttpRequest request) {
        Optional<ResponseHandler> handler = this.postSettings.getMatched(this.name, request);
        if (handler.isPresent()) {
            return handler;
        }
        if (this.singleMatcher.match(request)) {
            return Optional.of(NOT_FOUND_HANDLER);
        }
        return Optional.of(BAD_REQUEST_HANDLER);
    }

    private Optional<ResponseHandler> getSingleResponseHandler(CompositeRestSetting<RestSingleSetting> settings, HttpRequest httpRequest) {
        Optional<ResponseHandler> handler = settings.getMatched(this.name, httpRequest);
        if (handler.isPresent()) {
            return handler;
        }
        return Optional.of(NOT_FOUND_HANDLER);
    }

    public Optional<ResponseHandler> getResponseHandler(HttpRequest httpRequest) {
        if (this.allMatcher.match(httpRequest) || this.singleMatcher.match(httpRequest)) {
            return this.doGetResponseHandler(httpRequest);
        }
        return this.getSubResponseHandler(httpRequest);
    }

    private Optional<ResponseHandler> getSubResponseHandler(HttpRequest httpRequest) {
        for (SubResourceSetting subResourceSetting : this.subResourceSettings) {
            Optional<ResponseHandler> matched = subResourceSetting.getMatched(this.name, httpRequest);
            if (!matched.isPresent()) continue;
            return matched;
        }
        return Optional.empty();
    }

    private Optional<ResponseHandler> doGetResponseHandler(HttpRequest httpRequest) {
        HttpMethod method = httpRequest.getMethod();
        if (HttpMethod.GET == method) {
            return this.getGetHandler(httpRequest);
        }
        if (HttpMethod.POST == method) {
            return this.getPostHandler(httpRequest);
        }
        if (HttpMethod.PUT == method) {
            return this.getSingleResponseHandler(this.putSettings, httpRequest);
        }
        if (HttpMethod.DELETE == method) {
            return this.getSingleResponseHandler(this.deleteSettings, httpRequest);
        }
        if (HttpMethod.HEAD == method) {
            return this.getHeadHandler(httpRequest);
        }
        if (HttpMethod.PATCH == method) {
            return this.getSingleResponseHandler(this.patchSettings, httpRequest);
        }
        return Optional.empty();
    }
}

