/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestSetting;
import java.util.Optional;

public abstract class SimpleRestSetting
implements RestSetting {
    private final HttpMethod method;
    private final Optional<RequestMatcher> matcher;
    private final ResponseHandler handler;

    protected abstract RequestMatcher getBaseRequestMatcher(RestIdMatcher var1);

    public SimpleRestSetting(HttpMethod method, Optional<RequestMatcher> matcher, ResponseHandler handler) {
        this.method = method;
        this.matcher = matcher;
        this.handler = handler;
    }

    public final ResponseHandler getHandler() {
        return this.handler;
    }

    public final RequestMatcher getRequestMatcher(RestIdMatcher resourceName) {
        RequestMatcher rootMatcher = this.getBaseRequestMatcher(resourceName);
        if (this.matcher.isPresent()) {
            return Moco.and(rootMatcher, this.matcher.get());
        }
        return rootMatcher;
    }

    public final boolean isFor(HttpMethod method) {
        return this.method == method;
    }

    @Override
    public final boolean isSimple() {
        return true;
    }

    @Override
    public final Optional<ResponseHandler> getMatched(RestIdMatcher resourceName, HttpRequest httpRequest) {
        if (this.getRequestMatcher(resourceName).match(httpRequest)) {
            return Optional.of(this.handler);
        }
        return Optional.empty();
    }
}

