/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.deserializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.util.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;

public final class TextContainerDeserializerHelper {
    private static final ImmutableMap<String, String> NAMES = ImmutableMap.builder().put((Object)"json_path", (Object)"jsonPaths").put((Object)"xpath", (Object)"xpaths").put((Object)"header", (Object)"headers").put((Object)"cookie", (Object)"cookies").put((Object)"form", (Object)"forms").build();

    public TextContainer textContainer(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.FIELD_NAME) {
            String operation = Strings.strip((String)jp.getText());
            JsonToken token = jp.nextToken();
            if (TextContainer.isForTemplate(operation) && token == JsonToken.START_OBJECT) {
                Template template = (Template)jp.readValueAs(Template.class);
                jp.nextToken();
                return template.template();
            }
            if (token == JsonToken.VALUE_STRING) {
                String text = Strings.strip((String)jp.getText());
                jp.nextToken();
                return TextContainer.builder().withOperation(operation).withText(text).build();
            }
        }
        return (TextContainer)ctxt.handleUnexpectedToken(TextContainer.class, jp);
    }

    protected TextContainer text(JsonParser jp) throws IOException {
        return TextContainer.builder().withText(Strings.strip((String)jp.getText())).build();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class Template {
        private String with;
        private Map<String, TextContainer> vars;

        private Template() {
        }

        private ImmutableMap<String, TextContainer> toTemplateVars() {
            return ImmutableMap.copyOf((Map)Maps.transformEntries(this.vars, this.toLocalContainer()));
        }

        private Maps.EntryTransformer<String, TextContainer, TextContainer> toLocalContainer() {
            return new Maps.EntryTransformer<String, TextContainer, TextContainer>(){

                public TextContainer transformEntry(String key, TextContainer container) {
                    if (container.isRawText()) {
                        return container;
                    }
                    return this.toLocal(container);
                }
            };
        }

        private TextContainer toLocal(TextContainer container) {
            String name = (String)NAMES.get((Object)container.getOperation());
            if (name == null) {
                return container;
            }
            return TextContainer.builder().withOperation(name).withText(container.getText()).withProps(container.getProps()).build();
        }

        public TextContainer template() {
            return TextContainer.builder().withOperation(TextContainer.getTemplateName()).withText(this.with).withProps((Map<String, TextContainer>)this.toTemplateVars()).build();
        }
    }
}

