/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.extractor.Extractors;
import com.github.dreamhead.moco.matcher.AndRequestMatcher;
import com.github.dreamhead.moco.parser.RequestMatcherFactory;
import com.github.dreamhead.moco.parser.model.Dynamics;
import com.github.dreamhead.moco.parser.model.RequestSetting;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class DynamicRequestMatcherFactory
extends Dynamics
implements RequestMatcherFactory {
    @Override
    public RequestMatcher createRequestMatcher(RequestSetting request) {
        return DynamicRequestMatcherFactory.wrapRequestMatcher(request, this.createRequestMatchers(request));
    }

    private List<RequestMatcher> createRequestMatchers(RequestSetting request) {
        return StreamSupport.stream(this.getFields(RequestSetting.class).spliterator(), false).filter(this.isValidField(request)).map(this.fieldToRequestMatcher(request)).collect(Collectors.toList());
    }

    private Function<Field, RequestMatcher> fieldToRequestMatcher(RequestSetting request) {
        return field -> {
            try {
                Object value = field.get(request);
                return this.createRequestMatcherFromValue(field.getName(), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private RequestMatcher createRequestMatcherFromValue(String name, Object value) {
        if ("json".equalsIgnoreCase(name)) {
            return Moco.by((Resource)Moco.json((Object)value));
        }
        if (value instanceof Map) {
            return this.createCompositeMatcher(name, this.castToMap(value));
        }
        if (value instanceof TextContainer) {
            return this.createSingleTextMatcher(name, (TextContainer)value);
        }
        throw new IllegalArgumentException("unknown configuration :" + value);
    }

    private Map<String, Object> castToMap(Object value) {
        return (Map)value;
    }

    private RequestMatcher createSingleMatcher(String name, String value) {
        return Moco.by((Resource)this.createResource(name, value));
    }

    private Resource createResource(String name, String value) {
        return DynamicRequestMatcherFactory.invokeTarget(name, value, Resource.class);
    }

    private RequestMatcher createSingleTextMatcher(String name, TextContainer container) {
        if (container.isRawText()) {
            return this.createSingleMatcher(name, container.getText());
        }
        if (this.isExistOperator(container)) {
            return this.existMatcher(Extractors.extractor((String)name), container);
        }
        return this.createRequestMatcherWithResource(container.getOperation(), this.createResource(name, container.getText()));
    }

    private boolean isExistOperator(TextContainer container) {
        return "exist".equals(container.getOperation());
    }

    private RequestMatcher createRequestMatcherWithResource(String operation, Resource resource) {
        try {
            Method operationMethod = Moco.class.getMethod(operation, Resource.class);
            Object result = operationMethod.invoke(null, resource);
            Optional<RequestMatcher> matcher = this.createRequestMatcher(result);
            if (matcher.isPresent()) {
                return matcher.get();
            }
            throw new IllegalArgumentException("unknown operation [" + operation + "]");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<RequestMatcher> createRequestMatcher(Object result) {
        if (result instanceof RequestMatcher) {
            return Optional.of((RequestMatcher)result);
        }
        if (result instanceof ContentResource) {
            return Optional.of(Moco.by((Resource)((ContentResource)result)));
        }
        return Optional.empty();
    }

    private RequestMatcher createCompositeMatcher(String name, Map<String, Object> collection) {
        List<RequestMatcher> matchers = collection.entrySet().stream().map(this.toTargetMatcher(DynamicRequestMatcherFactory.getExtractorMethod(name))).collect(Collectors.toList());
        return DynamicRequestMatcherFactory.wrapRequestMatcher(null, matchers);
    }

    private Function<Map.Entry<String, Object>, RequestMatcher> toTargetMatcher(Method extractorMethod) {
        return pair -> {
            RequestExtractor extractor = DynamicRequestMatcherFactory.createRequestExtractor(extractorMethod, (String)pair.getKey());
            return this.createRequestMatcher(extractor, pair.getValue());
        };
    }

    private <T> RequestMatcher createRequestMatcher(RequestExtractor<T> extractor, Object value) {
        if (value instanceof TextContainer) {
            return this.getRequestMatcher(extractor, (TextContainer)value);
        }
        throw new IllegalArgumentException("unknown value type: " + value);
    }

    private <T> RequestMatcher getRequestMatcher(RequestExtractor<T> extractor, TextContainer container) {
        if (container.isRawText()) {
            return Moco.eq(extractor, (String)container.getText());
        }
        if (this.isExistOperator(container)) {
            return this.existMatcher(extractor, container);
        }
        try {
            Method operatorMethod = Moco.class.getMethod(container.getOperation(), RequestExtractor.class, String.class);
            Object result = operatorMethod.invoke(null, extractor, container.getText());
            return (RequestMatcher)result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> RequestMatcher existMatcher(RequestExtractor<T> extractor, TextContainer container) {
        String text = container.getText();
        if ("true".equalsIgnoreCase(text)) {
            return Moco.exist(extractor);
        }
        if ("false".equalsIgnoreCase(text)) {
            return Moco.not((RequestMatcher)Moco.exist(extractor));
        }
        throw new IllegalArgumentException(String.format("Unknown exist parameter: [%s]", text));
    }

    private static RequestMatcher wrapRequestMatcher(RequestSetting request, List<RequestMatcher> matchers) {
        switch (matchers.size()) {
            case 0: {
                throw new IllegalArgumentException("illegal request setting:" + request);
            }
            case 1: {
                return matchers.get(0);
            }
        }
        return new AndRequestMatcher(matchers);
    }
}

