/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner.watcher;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.runner.watcher.CompositeWatcher;
import com.github.dreamhead.moco.runner.watcher.DefaultWatcher;
import com.github.dreamhead.moco.runner.watcher.FileWatcherFactory;
import com.github.dreamhead.moco.runner.watcher.Watcher;
import com.github.dreamhead.moco.runner.watcher.WatcherService;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DefaultWatcherFactory
implements FileWatcherFactory {
    private WatcherService service = new WatcherService();

    @Override
    public Watcher createWatcher(Function<File, Void> listener, File ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("No file is specified");
        }
        try {
            this.service.start();
        }
        catch (IOException e) {
            throw new MocoException((Throwable)e);
        }
        return new CompositeWatcher(Arrays.stream(files).map(file -> new DefaultWatcher(this.service, listener, (File)file)).collect(Collectors.toList()));
    }
}

