/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.TableModelUtilsOfDb;
import com.github.drinkjava2.jdialects.TableModelUtilsOfEntity;
import com.github.drinkjava2.jdialects.TableModelUtilsOfJavaSrc;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class TableModelUtils {
    public static Class<?> tableNameToEntityClass(String tableName) {
        return TableModelUtilsOfEntity.tableNameToEntityClass(tableName);
    }

    public static TableModel entity2Model(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2EditableModel(entityClass);
    }

    public static TableModel[] entity2Models(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2EditableModels(entityClasses);
    }

    public static TableModel entity2ReadOnlyModel(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClass);
    }

    public static TableModel[] entity2ReadOnlyModels(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClasses);
    }

    public static TableModel[] db2Models(Connection con, Dialect dialect) {
        return TableModelUtilsOfDb.db2Models(con, dialect);
    }

    public static void db2JavaSrcFiles(DataSource ds, Dialect dialect, boolean linkStyle, boolean activeRecord, String packageName, String outputfolder) {
        block5: {
            Connection conn = null;
            try {
                TableModel[] models;
                conn = ds.getConnection();
                for (TableModel model : models = TableModelUtils.db2Models(conn, dialect)) {
                    File writename = new File(outputfolder + "/" + TableModelUtilsOfJavaSrc.getClassNameFromTableModel(model) + ".java");
                    writename.createNewFile();
                    BufferedWriter out = new BufferedWriter(new FileWriter(writename));
                    String javaSrc = TableModelUtils.model2JavaSrc(model, linkStyle, activeRecord, packageName);
                    out.write(javaSrc);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                if (conn == null) break block5;
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String model2JavaSrc(TableModel model, boolean linkStyle, boolean activeRecord, String packageName) {
        return TableModelUtilsOfJavaSrc.modelToJavaSourceCode(model, linkStyle, activeRecord, packageName);
    }

    public static void bindGlobalModel(Class<?> entityClass, TableModel tableModel) {
        TableModelUtilsOfEntity.globalTableModelCache.put(entityClass, tableModel);
    }
}

