/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.AutoIdGenerator;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.UUIDAnyGenerator;

public class SortedUUIDGenerator
implements IdGenerator {
    private String name;
    private int sortedLength;
    private int uuidLength;

    public SortedUUIDGenerator(String name, int sortedLength, int uuidLength) {
        this.name = name;
        this.sortedLength = sortedLength;
        this.uuidLength = uuidLength;
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.SORTED_UUID;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return true;
    }

    @Override
    public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
        String s = "" + AutoIdGenerator.INSTANCE.getNextID(jdbc, dialect, dataType);
        if (s.length() > this.sortedLength - 1) {
            throw new DialectException("SortedLength should set bigger than auto generated ID length");
        }
        StringBuilder sb = new StringBuilder("1");
        for (int i = 1; i < this.sortedLength - s.length(); ++i) {
            sb.append("0");
        }
        sb.append(s);
        sb.append(UUIDAnyGenerator.getAnyLengthRadix36UUID(this.uuidLength));
        return sb.toString();
    }

    @Override
    public IdGenerator newCopy() {
        return new SortedUUIDGenerator(this.name, this.sortedLength, this.uuidLength);
    }

    public String getName() {
        return this.name;
    }

    public int getSortedLength() {
        return this.sortedLength;
    }

    public int getUuidLength() {
        return this.uuidLength;
    }
}

