/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.log;

import com.github.drinkjava2.jdialects.log.DialectLog;
import com.github.drinkjava2.jdialects.log.DialectPrintLog;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

public abstract class DialectLogFactory {
    private static Class<?> dbProLogClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DialectLog getLog(Class<?> clazz) {
        if (dbProLogClass == Void.TYPE) {
            return new DialectPrintLog(clazz);
        }
        if (dbProLogClass != null) {
            try {
                Constructor<?> constr = dbProLogClass.getConstructor(Class.class);
                return (DialectLog)constr.newInstance(clazz);
            }
            catch (Exception e) {
                dbProLogClass = Void.TYPE;
                return new DialectPrintLog(clazz);
            }
        }
        InputStream is = DialectLog.class.getClassLoader().getResourceAsStream(DialectLog.class.getSimpleName() + ".properties");
        if (is == null) {
            dbProLogClass = Void.TYPE;
            return new DialectPrintLog(clazz);
        }
        Properties prop = new Properties();
        try {
            prop.load(is);
            String className = prop.getProperty("log");
            dbProLogClass = Class.forName(className);
            DialectLog dialectLog = DialectLogFactory.getLog(clazz);
            return dialectLog;
        }
        catch (Exception e) {
            dbProLogClass = Void.TYPE;
            DialectPrintLog dialectPrintLog = new DialectPrintLog(clazz);
            return dialectPrintLog;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }
}

