/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.model.TableModel;

public class UniqueModel {
    private String name;
    private String[] columnList;
    private TableModel tableModel;

    public UniqueModel() {
    }

    public UniqueModel(String name) {
        this.name = name;
    }

    public UniqueModel newCopy() {
        UniqueModel result = new UniqueModel();
        result.name = this.name;
        result.columnList = this.columnList;
        return result;
    }

    public UniqueModel columns(String ... columns) {
        this.checkReadOnly();
        this.columnList = columns;
        return this;
    }

    public void checkReadOnly() {
        if (this.tableModel != null && this.tableModel.getReadOnly().booleanValue()) {
            throw new DialectException("TableModel '" + this.tableModel.getTableName() + "' is readOnly, can not be modified.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkReadOnly();
        this.name = name;
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String[] columnList) {
        this.checkReadOnly();
        this.columnList = columnList;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.checkReadOnly();
        this.tableModel = tableModel;
    }
}

