/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectFunctionUtils;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jlogs.Log;
import com.github.drinkjava2.jlogs.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DialectFunctionTranslator {
    private static final Log logger = LogFactory.getLog(DialectFunctionTranslator.class);
    public static final DialectFunctionTranslator instance = new DialectFunctionTranslator();
    private Map<String, Integer> functionMap = new HashMap<String, Integer>();

    public DialectFunctionTranslator() {
        this.functionMap.put("ABS", 100);
        this.functionMap.put("AVG", 100);
        this.functionMap.put("BIT_LENGTH", 100);
        this.functionMap.put("CAST", 100);
        this.functionMap.put("COALESCE", 100);
        this.functionMap.put("COUNT", 100);
        this.functionMap.put("DAY", 100);
        this.functionMap.put("EXTRACT", 100);
        this.functionMap.put("HOUR", 100);
        this.functionMap.put("LENGTH", 100);
        this.functionMap.put("LOCATE", 100);
        this.functionMap.put("LOWER", 100);
        this.functionMap.put("MAX", 100);
        this.functionMap.put("MIN", 100);
        this.functionMap.put("MINUTE", 100);
        this.functionMap.put("MOD", 100);
        this.functionMap.put("MONTH", 100);
        this.functionMap.put("NULLIF", 100);
        this.functionMap.put("SECOND", 100);
        this.functionMap.put("SQRT", 100);
        this.functionMap.put("STR", 100);
        this.functionMap.put("SUBSTRING", 100);
        this.functionMap.put("SUM", 100);
        this.functionMap.put("TRIM", 100);
        this.functionMap.put("UPPER", 100);
        this.functionMap.put("YEAR", 100);
        this.functionMap.put("CONCAT", 93);
        this.functionMap.put("COS", 83);
        this.functionMap.put("EXP", 83);
        this.functionMap.put("SIN", 83);
        this.functionMap.put("LOG", 81);
        this.functionMap.put("ROUND", 81);
        this.functionMap.put("ATAN", 80);
        this.functionMap.put("SIGN", 80);
        this.functionMap.put("ACOS", 79);
        this.functionMap.put("ASIN", 79);
        this.functionMap.put("CURRENT_DATE", 79);
        this.functionMap.put("FLOOR", 79);
        this.functionMap.put("TAN", 79);
        this.functionMap.put("CURRENT_TIMESTAMP", 76);
        this.functionMap.put("CURRENT_TIME", 73);
        this.functionMap.put("COT", 69);
        this.functionMap.put("ASCII", 68);
        this.functionMap.put("RTRIM", 67);
        this.functionMap.put("LN", 65);
        this.functionMap.put("LTRIM", 65);
        this.functionMap.put("DEGREES", 64);
        this.functionMap.put("RADIANS", 63);
        this.functionMap.put("RAND", 63);
        this.functionMap.put("CEIL", 61);
        this.functionMap.put("SOUNDEX", 56);
        this.functionMap.put("USER", 56);
        this.functionMap.put("LOG10", 52);
        this.functionMap.put("SUBSTR", 51);
        this.functionMap.put("CEILING", 49);
        this.functionMap.put("STDDEV", 49);
        this.functionMap.put("NOW", 45);
        this.functionMap.put("CHAR_LENGTH", 44);
        this.functionMap.put("CHR", 44);
        this.functionMap.put("DAYOFYEAR", 44);
        this.functionMap.put("OCTET_LENGTH", 43);
        this.functionMap.put("PI", 43);
        this.functionMap.put("WEEK", 43);
        this.functionMap.put("DAYNAME", 41);
        this.functionMap.put("DAYOFWEEK", 41);
        this.functionMap.put("LCASE", 41);
        this.functionMap.put("MONTHNAME", 41);
        this.functionMap.put("QUARTER", 41);
        this.functionMap.put("SPACE", 41);
        this.functionMap.put("SYSDATE", 41);
        this.functionMap.put("UCASE", 41);
        this.functionMap.put("CHAR", 39);
        this.functionMap.put("REVERSE", 39);
        this.functionMap.put("HEX", 37);
        this.functionMap.put("LAST_DAY", 37);
        this.functionMap.put("MD5", 37);
        this.functionMap.put("TIME", 37);
        this.functionMap.put("TIMESTAMP", 37);
        this.functionMap.put("DATE", 36);
        this.functionMap.put("TRUNC", 36);
        this.functionMap.put("VARIANCE", 36);
        this.functionMap.put("INITCAP", 35);
        this.functionMap.put("POWER", 35);
        this.functionMap.put("DAYOFMONTH", 33);
        this.functionMap.put("ATAN2", 31);
        this.functionMap.put("CHARACTER_LENGTH", 31);
        this.functionMap.put("CURDATE", 29);
        this.functionMap.put("CURTIME", 29);
        this.functionMap.put("DATEDIFF", 29);
        this.functionMap.put("REPLACE", 29);
        this.functionMap.put("TO_DATE", 29);
        this.functionMap.put("LOCALTIME", 28);
        this.functionMap.put("LOCALTIMESTAMP", 28);
        this.functionMap.put("NVL", 28);
        this.functionMap.put("TO_CHAR", 28);
        this.functionMap.put("LPAD", 27);
        this.functionMap.put("RPAD", 27);
        this.functionMap.put("BIN", 24);
        this.functionMap.put("ENCRYPT", 24);
        this.functionMap.put("FROM_DAYS", 24);
        this.functionMap.put("LOG2", 24);
        this.functionMap.put("TIMEDIFF", 24);
        this.functionMap.put("TO_DAYS", 24);
        this.functionMap.put("WEEKOFYEAR", 24);
        this.functionMap.put("CRC32", 23);
        this.functionMap.put("INSTR", 23);
        this.functionMap.put("ISNULL", 23);
        this.functionMap.put("LEN", 23);
        this.functionMap.put("OCT", 23);
        this.functionMap.put("TRANSLATE", 23);
        this.functionMap.put("MICROSECOND", 21);
        this.functionMap.put("RIGHT", 21);
        this.functionMap.put("CURRENT_USER", 20);
        this.functionMap.put("RANDOM", 20);
        this.functionMap.put("SESSION_USER", 20);
        this.functionMap.put("LEFT", 19);
        this.functionMap.put("DATE_TRUNC", 17);
        this.functionMap.put("UNHEX", 17);
        this.functionMap.put("WEEKDAY", 17);
        this.functionMap.put("CURRENT_SCHEMA", 16);
        this.functionMap.put("POSITION", 16);
        this.functionMap.put("TO_TIMESTAMP", 16);
        this.functionMap.put("ADD_MONTHS", 15);
        this.functionMap.put("BIT_COUNT", 15);
        this.functionMap.put("COSH", 15);
        this.functionMap.put("FROM_UNIXTIME", 15);
        this.functionMap.put("GETDATE", 15);
        this.functionMap.put("QUOTE", 15);
        this.functionMap.put("SEC_TO_TIME", 15);
        this.functionMap.put("SINH", 15);
        this.functionMap.put("TANH", 15);
        this.functionMap.put("TIME_TO_SEC", 15);
        this.functionMap.put("TO_NUMBER", 15);
        this.functionMap.put("UNIX_TIMESTAMP", 15);
        this.functionMap.put("UTC_DATE", 15);
        this.functionMap.put("UTC_TIME", 15);
        this.functionMap.put("AGE", 13);
        this.functionMap.put("CBRT", 13);
        this.functionMap.put("CURRENT_DATABASE", 13);
        this.functionMap.put("DATABASE", 13);
        this.functionMap.put("DATENAME", 13);
        this.functionMap.put("DATE_FORMAT", 13);
        this.functionMap.put("DIFFERENCE", 13);
        this.functionMap.put("DOW", 13);
        this.functionMap.put("IFNULL", 13);
        this.functionMap.put("MICROSECONDS", 13);
        this.functionMap.put("NEXT_DAY", 13);
        this.functionMap.put("ORD", 13);
        this.functionMap.put("QUOTE_IDENT", 13);
        this.functionMap.put("QUOTE_LITERAL", 13);
        this.functionMap.put("REPLICATE", 13);
        this.functionMap.put("SHA", 13);
        this.functionMap.put("SHA1", 13);
        this.functionMap.put("TIMEOFDAY", 13);
        this.functionMap.put("TO_ASCII", 13);
        this.functionMap.put("TRUNCATE", 13);
        this.functionMap.put("UTC_TIMESTAMP", 13);
        this.functionMap.put("YEARWEEK", 13);
        this.functionMap.put("DATETIME", 12);
        this.functionMap.put("GETUTCDATE", 12);
        this.functionMap.put("MONTHS_BETWEEN", 12);
        this.functionMap.put("NVL2", 12);
        this.functionMap.put("REPEAT", 12);
        this.functionMap.put("ROWNUM", 12);
        this.functionMap.put("SQUARE", 12);
        this.functionMap.put("STUFF", 12);
        this.functionMap.put("BIGINT", 11);
        this.functionMap.put("COMPRESS", 11);
        this.functionMap.put("DAYS", 11);
        this.functionMap.put("DECRYPT", 11);
        this.functionMap.put("INSTRB", 11);
        this.functionMap.put("INTEGER", 11);
        this.functionMap.put("REAL", 11);
        this.functionMap.put("ROWID", 11);
        this.functionMap.put("SMALLINT", 11);
        this.functionMap.put("SYSTIMESTAMP", 11);
        this.functionMap.put("TIMESTAMPADD", 11);
        this.functionMap.put("TIMESTAMPDIFF", 11);
        this.functionMap.put("VARCHAR", 11);
    }

    public Map<String, Integer> getFunctionMap() {
        return this.functionMap;
    }

    public void setFunctionMap(Map<String, Integer> functionMap) {
        this.functionMap = functionMap;
    }

    public String doTranslate(Dialect d, String sql) {
        DialectSqlItem[] items;
        if (StrUtils.isEmpty(sql)) {
            return sql;
        }
        if (!StrUtils.isEmpty(Dialect.getGlobalSqlFunctionPrefix()) && !StrUtils.containsIgnoreCase(sql, Dialect.getGlobalSqlFunctionPrefix())) {
            return sql;
        }
        char[] chars = (" " + sql + " ").toCharArray();
        for (DialectSqlItem item : items = this.seperateCharsToItems(chars, 1, chars.length - 2)) {
            this.correctType(item);
        }
        String result = this.join(d, true, null, items);
        if (Dialect.getGlobalAllowShowSql().booleanValue()) {
            logger.info("Translated sql: " + result);
        }
        return result;
    }

    DialectSqlItem[] seperateCharsToItems(char[] chars, int start, int end) {
        ArrayList<DialectSqlItem> items = new ArrayList<DialectSqlItem>();
        SearchResult result = this.findFirstResult(chars, start, end);
        while (result != null) {
            items.add(result.item);
            result = this.findFirstResult(chars, result.leftStart, result.leftEnd);
        }
        return items.toArray(new DialectSqlItem[items.size()]);
    }

    void correctType(DialectSqlItem item) {
        if (item.type == 'U') {
            String valueStr = (String)item.value;
            String valueUpcase = valueStr.toUpperCase();
            String funPrefix = Dialect.getGlobalSqlFunctionPrefix();
            if (!StrUtils.isEmpty(valueUpcase)) {
                if (!StrUtils.isEmpty(funPrefix) && StrUtils.startsWithIgnoreCase(valueUpcase, funPrefix) && this.functionMap.containsKey(valueUpcase.substring(funPrefix.length()))) {
                    item.type = (char)70;
                    item.value = valueStr.substring(funPrefix.length());
                }
                if (StrUtils.isEmpty(funPrefix) && this.functionMap.containsKey(valueUpcase)) {
                    item.type = (char)70;
                    item.value = valueStr;
                }
            }
            if (item.type == 'U') {
                if (",".equals(valueStr)) {
                    item.setTypeAndValue(',', valueStr);
                } else {
                    item.setTypeAndValue('S', valueStr);
                }
            }
        }
        if (item.subItems != null) {
            for (DialectSqlItem t : item.subItems) {
                this.correctType(t);
            }
        }
    }

    SearchResult findFirstResult(char[] chars, int start, int end) {
        if (start > end) {
            return null;
        }
        boolean letters = false;
        StringBuilder sb = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            if (!letters) {
                if (chars[i] == ' ') {
                    DialectSqlItem item = new DialectSqlItem();
                    item.type = (char)83;
                    item.value = " ";
                    return new SearchResult(item, i + 1, end);
                }
                if (chars[i] == '?') {
                    DialectSqlItem item = new DialectSqlItem();
                    item.type = (char)83;
                    item.value = "?";
                    return new SearchResult(item, i + 1, end);
                }
                if (chars[i] == '\'') {
                    for (int j = i + 1; j <= end; ++j) {
                        if (chars[j] == '\'' && chars[j - 1] != '\\') {
                            DialectSqlItem item = new DialectSqlItem();
                            item.type = (char)83;
                            item.value = sb.insert(0, '\'').append('\'').toString();
                            return new SearchResult(item, j + 1, end);
                        }
                        sb.append(chars[j]);
                    }
                    throw new DialectException("Miss right ' charactor in SQL.");
                }
                if (chars[i] == '(') {
                    int count = 1;
                    boolean inString = false;
                    for (int j = i + 1; j <= end; ++j) {
                        if (!inString) {
                            if (chars[j] == '(') {
                                ++count;
                                continue;
                            }
                            if (chars[j] == ')') {
                                if (--count != 0) continue;
                                DialectSqlItem[] subItems = this.seperateCharsToItems(chars, i + 1, j - 1);
                                DialectSqlItem item = new DialectSqlItem();
                                item.type = (char)40;
                                item.subItems = subItems;
                                return new SearchResult(item, j + 1, end);
                            }
                            if (chars[j] != '\'') continue;
                            inString = true;
                            continue;
                        }
                        if (chars[j] != '\'' || chars[j - 1] == '\\') continue;
                        inString = false;
                    }
                    throw new DialectException("Miss right ) charactor in SQL.");
                }
                if (chars[i] <= ' ') continue;
                letters = true;
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '?' || chars[i] == '\'' || chars[i] == '(' || chars[i] <= ' ' || DialectFunctionTranslator.isLetterNumber(chars[i]) != DialectFunctionTranslator.isLetterNumber(chars[i - 1])) {
                DialectSqlItem item = new DialectSqlItem();
                item.type = (char)85;
                item.value = sb.toString();
                return new SearchResult(item, i, end);
            }
            sb.append(chars[i]);
        }
        if (sb.length() > 0) {
            DialectSqlItem item = new DialectSqlItem();
            item.type = (char)85;
            item.value = sb.toString();
            return new SearchResult(item, end + 1, end);
        }
        return null;
    }

    String join(Dialect d, boolean isTopLevel, DialectSqlItem function, DialectSqlItem[] items) {
        int pos = 0;
        for (DialectSqlItem item : items) {
            if (item.subItems != null) {
                String value = pos > 0 && items[pos - 1] != null && items[pos - 1].type == 'F' ? this.join(d, false, items[pos - 1], item.subItems) : this.join(d, false, null, item.subItems);
                item.type = (char)83;
                item.value = value;
                item.subItems = null;
            }
            ++pos;
        }
        if (function != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (DialectSqlItem item : items) {
                if (item.type == '0') continue;
                l.add((String)item.value);
            }
            return DialectFunctionTranslator.renderFunction(d, function, l.toArray(new String[l.size()]));
        }
        StringBuilder sb = new StringBuilder();
        if (!isTopLevel) {
            sb.append("(");
        }
        for (DialectSqlItem item : items) {
            if (item.type == '0') continue;
            sb.append(item.value);
        }
        if (!isTopLevel) {
            sb.append(")");
        }
        return sb.toString();
    }

    private static String renderFunction(Dialect d, DialectSqlItem function, String ... params) {
        function.type = (char)48;
        ArrayList<String> l = new ArrayList<String>();
        String current = "";
        for (String param : params) {
            if (",".equals(param)) {
                l.add(current);
                current = "";
                continue;
            }
            current = current + param;
        }
        String lastValue = current.trim();
        if (lastValue.length() > 0) {
            l.add(current);
        }
        return DialectFunctionUtils.render(d, (String)function.value, l.toArray(new String[l.size()]));
    }

    public static void deleteItem(DialectSqlItem item) {
        if (item != null) {
            item.type = (char)48;
        }
    }

    public static void deleteItem(DialectSqlItem lastItem, DialectSqlItem nextItem) {
        if (lastItem != null) {
            lastItem.type = (char)48;
        }
        if (nextItem != null) {
            nextItem.type = (char)48;
        }
    }

    public static boolean isLetterNumber(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_' || c == '.' || c == '@' || c == '#' || c == '$' || c == '+' || c == '-';
    }

    static class ParamPosition {
        int position = 0;

        ParamPosition() {
        }
    }

    static class SearchResult {
        DialectSqlItem item;
        int leftStart;
        int leftEnd;

        SearchResult(DialectSqlItem item, int leftStart, int leftEnd) {
            this.item = item;
            this.leftStart = leftStart;
            this.leftEnd = leftEnd;
        }
    }

    static class DialectSqlItem {
        public char type;
        public Object value;
        DialectSqlItem[] subItems;

        DialectSqlItem() {
        }

        void setTypeAndValue(char type, Object value) {
            this.type = type;
            this.value = value;
        }

        String getDebugInfo(int include) {
            String result = "\r";
            for (int i = 0; i < include; ++i) {
                result = result + "     ";
            }
            result = result + this.type + " ";
            if (this.value != null) {
                result = result + this.value;
            }
            if (this.subItems != null) {
                for (DialectSqlItem Item : this.subItems) {
                    result = result + Item.getDebugInfo(include + 1);
                }
            }
            return result;
        }
    }
}

