/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public abstract class TableModelUtilsOfDb {
    private static final String TABLE_NAME = "TABLE_NAME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableModel[] db2Models(Connection con, Dialect dialect) {
        ArrayList<TableModel> tableModels = new ArrayList<TableModel>();
        SQLException sqlException = null;
        ResultSet rs = null;
        Statement pst = null;
        try {
            DatabaseMetaData meta = con.getMetaData();
            String catalog = con.getCatalog();
            rs = meta.getTables(catalog, dialect.isOracleFamily() ? meta.getUserName() : null, null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString(TABLE_NAME);
                if (StrUtils.isEmpty(tableName)) continue;
                TableModel model = new TableModel(tableName);
                tableModels.add(model);
                String comment = rs.getString("REMARKS");
                if (StrUtils.isEmpty(comment)) continue;
                model.setComment(comment);
            }
            rs.close();
            for (TableModel model : tableModels) {
                String tableName = model.getTableName();
                rs = meta.getColumns(null, null, tableName, null);
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    ColumnModel col = new ColumnModel(colName);
                    model.addColumn(col);
                    int javaSqlType = rs.getInt("DATA_TYPE");
                    try {
                        col.setColumnType(TypeUtils.javaSqlTypeToDialectType(javaSqlType));
                    }
                    catch (Exception e1) {
                        throw new DialectException("jDialect does not supported java.sql.types value " + javaSqlType, e1);
                    }
                    col.setLength(rs.getInt("CHAR_OCTET_LENGTH"));
                    col.setPrecision(rs.getInt("COLUMN_SIZE"));
                    col.setScale(rs.getInt("DECIMAL_DIGITS"));
                    col.setNullable(rs.getInt("NULLABLE") > 0);
                    col.setDefaultValue(rs.getString("COLUMN_DEF"));
                    col.setComment(rs.getString("REMARKS"));
                    try {
                        if (Boolean.valueOf(true).equals(rs.getBoolean("IS_AUTOINCREMENT"))) {
                            col.identityId();
                        }
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    try {
                        if (!"YES".equalsIgnoreCase(rs.getString("IS_AUTOINCREMENT"))) continue;
                        col.identityId();
                    }
                    catch (Exception e1) {}
                }
                rs.close();
            }
            for (TableModel model : tableModels) {
                rs = meta.getPrimaryKeys(catalog, null, model.getTableName());
                while (rs.next()) {
                    model.getColumnByColName(rs.getString("COLUMN_NAME")).setPkey(true);
                }
                rs.close();
            }
            for (TableModel model : tableModels) {
                ResultSet foreignKeyResultSet = meta.getImportedKeys(catalog, null, model.getTableName());
                while (foreignKeyResultSet.next()) {
                    String fkname = foreignKeyResultSet.getString("FK_NAME");
                    int keyseq = foreignKeyResultSet.getInt("KEY_SEQ");
                    String fkColumnName = foreignKeyResultSet.getString("FKCOLUMN_NAME");
                    String pkTablenName = foreignKeyResultSet.getString("PKTABLE_NAME");
                    String pkColumnName = foreignKeyResultSet.getString("PKCOLUMN_NAME");
                    FKeyModel fkeyModel = model.getFkey(fkname);
                    if (keyseq == 1) {
                        model.fkey(fkname).columns(fkColumnName).refs(pkTablenName, pkColumnName);
                        continue;
                    }
                    fkeyModel.getColumnNames().add(fkColumnName);
                    String[] newRefs = ArrayUtils.appendStrArray(fkeyModel.getRefTableAndColumns(), pkColumnName);
                    fkeyModel.setRefTableAndColumns(newRefs);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            sqlException = e;
        }
        finally {
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e1) {
                    if (sqlException != null) {
                        sqlException.setNextException(e1);
                    }
                    sqlException = e1;
                }
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                if (sqlException != null) {
                    sqlException.setNextException(e2);
                }
                sqlException = e2;
            }
        }
        if (sqlException != null) {
            throw new DialectException(sqlException);
        }
        return tableModels.toArray(new TableModel[tableModels.size()]);
    }
}

