/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;

public abstract class TableModelUtilsOfJavaSrc {
    private static String transColumnNameToFieldName(String colName) {
        if (StrUtils.isEmpty(colName)) {
            return colName;
        }
        if (!colName.contains("_")) {
            return StrUtils.toLowerCaseFirstOne(colName);
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = colName.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_') continue;
            if (i > 0 && chars[i - 1] == '_' && sb.length() > 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getClassNameFromTableModel(TableModel model) {
        String className;
        DialectException.assureNotNull(model, "TableModel can not be null");
        if (model.getEntityClass() != null) {
            className = model.getEntityClass().getSimpleName();
        } else {
            DialectException.assureNotEmpty(model.getTableName(), "TableName can not be empty in TableModel");
            className = StrUtils.toUpperCaseFirstOne(TableModelUtilsOfJavaSrc.transColumnNameToFieldName(model.getTableName()));
        }
        DialectException.assureNotEmpty(className, "TableName can not be empty in TableModel");
        return className;
    }

    public static String modelToJavaSourceCode(TableModel model, boolean linkStyle, boolean activeRecord, String packageName) {
        String fieldName;
        Class<?> javaType;
        StringBuilder body = new StringBuilder();
        if (!StrUtils.isEmpty(packageName)) {
            body.append("package ").append(packageName).append(";\n");
        }
        body.append("import com.github.drinkjava2.jdialects.annotation.jdia.*;\n");
        body.append("import com.github.drinkjava2.jdialects.annotation.jpa.*;\n");
        if (activeRecord) {
            body.append("import com.github.drinkjava2.jsqlbox.*;\n");
            body.append("import static com.github.drinkjava2.jsqlbox.JSQLBOX.*;\n");
        }
        body.append("\n");
        String className = TableModelUtilsOfJavaSrc.getClassNameFromTableModel(model);
        if (!className.equals(model.getTableName())) {
            body.append("@Table").append("(name=\"").append(model.getTableName()).append("\")\n");
        }
        int fkeyCount = 0;
        for (FKeyModel fkey : model.getFkeyConstraints()) {
            if (fkey.getColumnNames().size() <= 1) continue;
            body.append("@FKey");
            if (fkeyCount > 0) {
                body.append(fkeyCount);
            }
            body.append("(");
            ++fkeyCount;
            if (!StrUtils.isEmpty(fkey.getFkeyName())) {
                body.append("name=\"").append(fkey.getFkeyName()).append("\", ");
            }
            if (!fkey.getDdl().booleanValue()) {
                body.append("ddl=false, ");
            }
            String fkeyCols = StrUtils.listToString(fkey.getColumnNames());
            fkeyCols = StrUtils.replace(fkeyCols, ",", "\",\"");
            String refCols = StrUtils.arrayToString(fkey.getRefTableAndColumns());
            refCols = StrUtils.replace(refCols, ",", "\",\"");
            body.append("columns={\"").append(fkeyCols).append("\"}, refs={\"").append(refCols).append("\"}");
            body.append(")\n");
        }
        if (activeRecord) {
            body.append("public class ").append(className).append(" extends ActiveRecord<").append(className).append("> {\n");
        } else {
            body.append("public class ").append(className).append(" {\n");
        }
        StringBuilder pkeySB = new StringBuilder();
        StringBuilder normalSB = new StringBuilder();
        StringBuilder sb = null;
        for (ColumnModel col : model.getColumns()) {
            boolean isStr;
            javaType = TypeUtils.dialectTypeToJavaType(col.getColumnType());
            if (javaType == null) continue;
            sb = col.getPkey() != false ? pkeySB : normalSB;
            fieldName = col.getEntityField();
            if (StrUtils.isEmpty(fieldName)) {
                fieldName = TableModelUtilsOfJavaSrc.transColumnNameToFieldName(col.getColumnName());
            }
            if (col.getPkey().booleanValue()) {
                sb.append("  @Id\n");
            }
            boolean bl = isStr = Type.VARCHAR.equals((Object)col.getColumnType()) || Type.CHAR.equals((Object)col.getColumnType());
            if (!fieldName.equalsIgnoreCase(col.getColumnName()) || isStr && 255 != col.getLength()) {
                sb.append("  @Column(name=\"").append(col.getColumnName()).append("\"");
                if (isStr && 255 != col.getLength()) {
                    sb.append(", length=").append(col.getLength());
                }
                sb.append(")\n");
            }
            for (FKeyModel fkey : model.getFkeyConstraints()) {
                if (fkey.getColumnNames().size() != 1 || !col.getColumnName().equalsIgnoreCase(fkey.getColumnNames().get(0))) continue;
                sb.append("  @SingleFKey");
                sb.append("(");
                ++fkeyCount;
                if (!StrUtils.isEmpty(fkey.getFkeyName())) {
                    sb.append("name=\"").append(fkey.getFkeyName()).append("\", ");
                }
                if (!fkey.getDdl().booleanValue()) {
                    sb.append("ddl=false, ");
                }
                String refCols = StrUtils.arrayToString(fkey.getRefTableAndColumns());
                refCols = StrUtils.replace(refCols, ",", "\",\"");
                sb.append("refs={\"").append(refCols).append("\"}");
                sb.append(")\n");
            }
            sb.append("  private ").append(javaType.getSimpleName()).append(" ").append(fieldName).append(";\n\n");
        }
        body.append(pkeySB.toString()).append(normalSB.toString());
        pkeySB.setLength(0);
        normalSB.setLength(0);
        for (ColumnModel col : model.getColumns()) {
            javaType = TypeUtils.dialectTypeToJavaType(col.getColumnType());
            if (javaType == null) continue;
            sb = col.getPkey() != false ? pkeySB : normalSB;
            fieldName = col.getEntityField();
            if (StrUtils.isEmpty(fieldName)) {
                fieldName = TableModelUtilsOfJavaSrc.transColumnNameToFieldName(col.getColumnName());
            }
            String getFieldName = "get" + StrUtils.toUpperCaseFirstOne(fieldName);
            sb.append("  public ").append(javaType.getSimpleName()).append(" ").append(getFieldName).append("(){\n");
            sb.append("    return ").append(fieldName).append(";\n");
            sb.append("  }\n\n");
            String setFieldName = "set" + StrUtils.toUpperCaseFirstOne(fieldName);
            sb.append("  public ").append(linkStyle ? className : "void").append(" ").append(setFieldName).append("(").append(javaType.getSimpleName()).append(" ").append(fieldName).append("){\n");
            sb.append("    this.").append(fieldName).append("=").append(fieldName).append(";\n");
            if (linkStyle) {
                sb.append("    return this;\n");
            }
            sb.append("  }\n\n");
        }
        body.append(pkeySB.toString()).append(normalSB.toString());
        body.append("}");
        return body.toString();
    }
}

