/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.Java8DateUtils;
import com.github.drinkjava2.jdialects.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeUtils {
    public static final String BIGINT = "BIGINT";
    public static final String BINARY = "BINARY";
    public static final String BIT = "BIT";
    public static final String BLOB = "BLOB";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String CHAR = "CHAR";
    public static final String CLOB = "CLOB";
    public static final String DATE = "DATE";
    public static final String DECIMAL = "DECIMAL";
    public static final String DOUBLE = "DOUBLE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String JAVA_OBJECT = "JAVA_OBJECT";
    public static final String LONGNVARCHAR = "LONGNVARCHAR";
    public static final String LONGVARBINARY = "LONGVARBINARY";
    public static final String LONGVARCHAR = "LONGVARCHAR";
    public static final String NCHAR = "NCHAR";
    public static final String NCLOB = "NCLOB";
    public static final String NUMERIC = "NUMERIC";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String UNKNOW = "UNKNOW";
    public static final String REAL = "REAL";
    public static final String SMALLINT = "SMALLINT";
    public static final String TIME = "TIME";
    public static final String TIMESTAMP = "TIMESTAMP";
    public static final String TINYINT = "TINYINT";
    public static final String VARBINARY = "VARBINARY";
    public static final String VARCHAR = "VARCHAR";
    private static final Map<Class<?>, Type> JAVA_TO_TYPE_MAP = new HashMap();
    private static final Map<Type, Class<?>> TYPE_TO_JAVA_MAP = new HashMap();

    @Deprecated
    public static boolean canMapToSqlType(Class<?> clazz) {
        return TypeUtils.canMapToDialectType(clazz);
    }

    public static boolean canMapToDialectType(Class<?> clazz) {
        return JAVA_TO_TYPE_MAP.containsKey(clazz);
    }

    public static Class<?> dialectTypeToJavaType(Type type) {
        return TYPE_TO_JAVA_MAP.get((Object)type);
    }

    @Deprecated
    public static Type toType(Class<?> clazz) {
        return TypeUtils.javaType2DialectType(clazz);
    }

    public static Type javaType2DialectType(Class<?> clazz) {
        return JAVA_TO_TYPE_MAP.get(clazz);
    }

    @Deprecated
    public static Type toType(String columnDef) {
        return TypeUtils.colDef2DialectType(columnDef);
    }

    public static Type colDef2DialectType(String columnDef) {
        if (BIGINT.equalsIgnoreCase(columnDef)) {
            return Type.BIGINT;
        }
        if (BINARY.equalsIgnoreCase(columnDef)) {
            return Type.BINARY;
        }
        if (BIT.equalsIgnoreCase(columnDef)) {
            return Type.BIT;
        }
        if (BLOB.equalsIgnoreCase(columnDef)) {
            return Type.BLOB;
        }
        if (BOOLEAN.equalsIgnoreCase(columnDef)) {
            return Type.BOOLEAN;
        }
        if (CHAR.equalsIgnoreCase(columnDef)) {
            return Type.CHAR;
        }
        if (CLOB.equalsIgnoreCase(columnDef)) {
            return Type.CLOB;
        }
        if (DATE.equalsIgnoreCase(columnDef)) {
            return Type.DATE;
        }
        if (DECIMAL.equalsIgnoreCase(columnDef)) {
            return Type.DECIMAL;
        }
        if (DOUBLE.equalsIgnoreCase(columnDef)) {
            return Type.DOUBLE;
        }
        if (FLOAT.equalsIgnoreCase(columnDef)) {
            return Type.FLOAT;
        }
        if (INTEGER.equalsIgnoreCase(columnDef)) {
            return Type.INTEGER;
        }
        if (JAVA_OBJECT.equalsIgnoreCase(columnDef)) {
            return Type.JAVA_OBJECT;
        }
        if (LONGNVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.LONGNVARCHAR;
        }
        if (LONGVARBINARY.equalsIgnoreCase(columnDef)) {
            return Type.LONGVARBINARY;
        }
        if (LONGVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.LONGVARCHAR;
        }
        if (NCHAR.equalsIgnoreCase(columnDef)) {
            return Type.NCHAR;
        }
        if (NCLOB.equalsIgnoreCase(columnDef)) {
            return Type.NCLOB;
        }
        if (NUMERIC.equalsIgnoreCase(columnDef)) {
            return Type.NUMERIC;
        }
        if (NVARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.NVARCHAR;
        }
        if (UNKNOW.equalsIgnoreCase(columnDef)) {
            return Type.UNKNOW;
        }
        if (REAL.equalsIgnoreCase(columnDef)) {
            return Type.REAL;
        }
        if (SMALLINT.equalsIgnoreCase(columnDef)) {
            return Type.SMALLINT;
        }
        if (TIME.equalsIgnoreCase(columnDef)) {
            return Type.TIME;
        }
        if (TIMESTAMP.equalsIgnoreCase(columnDef)) {
            return Type.TIMESTAMP;
        }
        if (TINYINT.equalsIgnoreCase(columnDef)) {
            return Type.TINYINT;
        }
        if (VARBINARY.equalsIgnoreCase(columnDef)) {
            return Type.VARBINARY;
        }
        if (VARCHAR.equalsIgnoreCase(columnDef)) {
            return Type.VARCHAR;
        }
        throw new DialectException("'" + columnDef + "' is not a legal SQL column definition name");
    }

    public static Object jdbcValue2JavaValue(Object value, Class<?> javaType) {
        if (value == null) {
            return null;
        }
        if (javaType == String.class) {
            return value.toString();
        }
        Class<?> vType = value.getClass();
        if (javaType.isAssignableFrom(vType)) {
            return value;
        }
        if (vType == BigDecimal.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((BigDecimal)value).intValue();
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((BigDecimal)value).longValue();
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((BigDecimal)value).byteValue();
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((BigDecimal)value).doubleValue();
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((BigDecimal)value).shortValue();
            }
            if (javaType == Boolean.class || javaType == Boolean.TYPE) {
                return ((BigDecimal)value).byteValue() != 0;
            }
        } else if (vType == Integer.class) {
            if (javaType == Integer.TYPE) {
                return (int)((Integer)value);
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((Integer)value).longValue();
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((Integer)value).byteValue();
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((Integer)value).doubleValue();
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((Integer)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((Integer)value).shortValue();
            }
        } else if (vType == Long.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((Long)value).intValue();
            }
            if (javaType == Long.TYPE) {
                return (long)((Long)value);
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((Long)value).byteValue();
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((Long)value).doubleValue();
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((Long)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((Long)value).shortValue();
            }
        } else if (vType == Double.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((Double)value).intValue();
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((Double)value).longValue();
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((Double)value).byteValue();
            }
            if (javaType == Double.TYPE) {
                return (double)((Double)value);
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((Double)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((Double)value).shortValue();
            }
        } else if (vType == Float.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((Float)value).intValue();
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((Float)value).longValue();
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((Float)value).byteValue();
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((Float)value).doubleValue();
            }
            if (javaType == Float.TYPE) {
                return Float.valueOf(((Float)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((Float)value).shortValue();
            }
        } else if (vType == Short.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((Short)value).intValue();
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((Short)value).longValue();
            }
            if (javaType == Byte.class || javaType == Byte.TYPE) {
                return ((Short)value).byteValue();
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((Short)value).doubleValue();
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((Short)value).floatValue());
            }
            if (javaType == Short.TYPE) {
                return (short)((Short)value);
            }
        } else if (vType == Byte.class) {
            if (javaType == Integer.class || javaType == Integer.TYPE) {
                return ((Byte)value).intValue();
            }
            if (javaType == Long.class || javaType == Long.TYPE) {
                return ((Byte)value).longValue();
            }
            if (javaType == Byte.TYPE) {
                return (byte)((Byte)value);
            }
            if (javaType == Double.class || javaType == Double.TYPE) {
                return ((Byte)value).doubleValue();
            }
            if (javaType == Float.class || javaType == Float.TYPE) {
                return Float.valueOf(((Byte)value).floatValue());
            }
            if (javaType == Short.class || javaType == Short.TYPE) {
                return ((Byte)value).shortValue();
            }
        } else if (vType == Date.class) {
            if (javaType == Timestamp.class) {
                return new Timestamp(((Date)value).getTime());
            }
            if (javaType == Time.class) {
                return new Time(((Date)value).getTime());
            }
            if (javaType == Calendar.class) {
                Calendar c = Calendar.getInstance();
                c.setTime((Date)value);
                return c;
            }
        } else if (vType == Time.class) {
            if (javaType == Timestamp.class) {
                return new Timestamp(((Time)value).getTime());
            }
            if (javaType == Date.class) {
                return new Date(((Time)value).getTime());
            }
        } else if (vType == Timestamp.class) {
            if (javaType == Date.class) {
                return new Date(((Timestamp)value).getTime());
            }
            if (javaType == Time.class) {
                return new Time(((Timestamp)value).getTime());
            }
            if (javaType == Calendar.class) {
                Calendar c = Calendar.getInstance();
                c.setTime(new java.util.Date(((Timestamp)value).getTime()));
                return c;
            }
        } else if (vType == java.util.Date.class) {
            if (javaType == Timestamp.class) {
                return new Timestamp(((java.util.Date)value).getTime());
            }
            if (javaType == Date.class) {
                return new java.util.Date(((java.util.Date)value).getTime());
            }
            if (javaType == Time.class) {
                return new Time(((java.util.Date)value).getTime());
            }
            if (javaType == Calendar.class) {
                Calendar c = Calendar.getInstance();
                c.setTime((java.util.Date)value);
                return c;
            }
        }
        return TypeUtils.jdbcValue2Java8Value(value, vType, javaType);
    }

    private static Object jdbcValue2Java8Value(Object value, Class<?> vType, Class<?> javaType) {
        if (vType == Date.class) {
            if (javaType == LocalDate.class) {
                return Java8DateUtils.sqlDate2localDate((Date)value);
            }
            if (javaType == LocalDateTime.class) {
                return Java8DateUtils.sqlDate2localDateTime((Date)value);
            }
        } else if (vType == Time.class) {
            if (javaType == LocalTime.class) {
                return Java8DateUtils.sqlTime2LocalTime((Time)value);
            }
            if (javaType == OffsetTime.class) {
                return Java8DateUtils.sqlTime2OffsetTime((Time)value);
            }
        } else if (vType == Timestamp.class) {
            if (javaType == LocalDate.class) {
                return Java8DateUtils.sqlTimestamp2LocalDate((Timestamp)value);
            }
            if (javaType == LocalTime.class) {
                return Java8DateUtils.sqlTimestamp2LocalTime((Timestamp)value);
            }
            if (javaType == Instant.class) {
                return Java8DateUtils.sqlTimestamp2instant((Timestamp)value);
            }
            if (javaType == LocalDateTime.class) {
                return Java8DateUtils.sqlTimestamp2LocalDateTime((Timestamp)value);
            }
            if (javaType == OffsetDateTime.class) {
                return Java8DateUtils.sqlTimestamp2OffsetDateTime((Timestamp)value);
            }
            if (javaType == ZonedDateTime.class) {
                return Java8DateUtils.sqlTimestamp2ZonedDateTime((Timestamp)value);
            }
            if (javaType == OffsetTime.class) {
                return Java8DateUtils.sqlTimestamp2OffsetTime((Timestamp)value);
            }
        } else if (vType == java.util.Date.class) {
            if (javaType == LocalDate.class) {
                return Java8DateUtils.date2LocalDate((java.util.Date)value);
            }
            if (javaType == LocalDateTime.class) {
                return Java8DateUtils.date2LocalDateTime((java.util.Date)value);
            }
        }
        String oracleTip = "oracle.sql.TIMESTAMP".equals(vType.getName()) ? "\nBelow setting may solve this Oracle JDBC compliant issue:\nSystem.getProperties().setProperty(\"oracle.jdbc.J2EE13Compliant\", \"true\");" : "";
        throw new DialectException("Can not convert jdbc type: '" + value.getClass() + "' with value '" + value + "' to jave type:" + javaType + oracleTip);
    }

    public static void javaParam2JdbcSqlParam(Object[] params, Type optionalType) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            Object value = params[i];
            if (value == null) continue;
            Class<?> vType = value.getClass();
            if (java.util.Date.class == vType) {
                params[i] = new Date(((java.util.Date)value).getTime());
                continue;
            }
            if (Calendar.class.isAssignableFrom(vType)) {
                params[i] = new Date(((Calendar)value).getTime().getTime());
                continue;
            }
            if (!Temporal.class.isAssignableFrom(vType)) continue;
            if (LocalDate.class == vType) {
                params[i] = Java8DateUtils.localDate2SqlDate((LocalDate)value);
                continue;
            }
            if (LocalTime.class == vType) {
                params[i] = Java8DateUtils.localTime2SqlTime((LocalTime)value);
                continue;
            }
            if (OffsetTime.class == vType) {
                params[i] = Java8DateUtils.offsetTime2SqlTime((OffsetTime)value);
                continue;
            }
            if (Instant.class == vType) {
                params[i] = Java8DateUtils.instant2SqlTimestamp((Instant)value);
                continue;
            }
            if (LocalDateTime.class == vType) {
                params[i] = Java8DateUtils.localDateTime2SqlTimestamp((LocalDateTime)value);
                continue;
            }
            if (OffsetDateTime.class == vType) {
                params[i] = Java8DateUtils.offsetDateTime2SqlTimestamp((OffsetDateTime)value);
                continue;
            }
            if (ZonedDateTime.class != vType) continue;
            params[i] = Java8DateUtils.zonedDateTime2SqlTimestamp((ZonedDateTime)value);
        }
    }

    public static Type javaSqlTypeToDialectType(int javaSqlType) {
        switch (javaSqlType) {
            case -7: {
                return Type.BIT;
            }
            case -6: {
                return Type.TINYINT;
            }
            case 5: {
                return Type.SMALLINT;
            }
            case 4: {
                return Type.INTEGER;
            }
            case -5: {
                return Type.BIGINT;
            }
            case 6: {
                return Type.FLOAT;
            }
            case 7: {
                return Type.REAL;
            }
            case 8: {
                return Type.DOUBLE;
            }
            case 2: {
                return Type.NUMERIC;
            }
            case 3: {
                return Type.DECIMAL;
            }
            case 1: {
                return Type.CHAR;
            }
            case 12: {
                return Type.VARCHAR;
            }
            case -1: {
                return Type.LONGVARCHAR;
            }
            case 91: {
                return Type.DATE;
            }
            case 92: {
                return Type.TIME;
            }
            case 93: {
                return Type.TIMESTAMP;
            }
            case -2: {
                return Type.BINARY;
            }
            case -3: {
                return Type.VARBINARY;
            }
            case -4: {
                return Type.LONGVARBINARY;
            }
            case 1111: {
                return Type.UNKNOW;
            }
            case 2000: {
                return Type.JAVA_OBJECT;
            }
            case 2004: {
                return Type.BLOB;
            }
            case 2005: {
                return Type.CLOB;
            }
            case 16: {
                return Type.BOOLEAN;
            }
            case -15: {
                return Type.NCHAR;
            }
            case -9: {
                return Type.NVARCHAR;
            }
            case -16: {
                return Type.LONGNVARCHAR;
            }
            case 2011: {
                return Type.NCLOB;
            }
        }
        throw new DialectException("Unsupported java.sql.Types:" + javaSqlType);
    }

    static {
        JAVA_TO_TYPE_MAP.put(BigDecimal.class, Type.NUMERIC);
        JAVA_TO_TYPE_MAP.put(BigInteger.class, Type.BIGINT);
        JAVA_TO_TYPE_MAP.put(Boolean.class, Type.BOOLEAN);
        JAVA_TO_TYPE_MAP.put(Byte.class, Type.TINYINT);
        JAVA_TO_TYPE_MAP.put(Character.class, Type.CHAR);
        JAVA_TO_TYPE_MAP.put(Double.class, Type.DOUBLE);
        JAVA_TO_TYPE_MAP.put(Float.class, Type.FLOAT);
        JAVA_TO_TYPE_MAP.put(Integer.class, Type.INTEGER);
        JAVA_TO_TYPE_MAP.put(Long.class, Type.BIGINT);
        JAVA_TO_TYPE_MAP.put(Short.class, Type.SMALLINT);
        JAVA_TO_TYPE_MAP.put(String.class, Type.VARCHAR);
        JAVA_TO_TYPE_MAP.put(Clob.class, Type.CLOB);
        JAVA_TO_TYPE_MAP.put(Blob.class, Type.BLOB);
        JAVA_TO_TYPE_MAP.put(java.util.Date.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Date.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Calendar.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(Time.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(Timestamp.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(LocalDate.class, Type.DATE);
        JAVA_TO_TYPE_MAP.put(LocalTime.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(OffsetTime.class, Type.TIME);
        JAVA_TO_TYPE_MAP.put(Instant.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(LocalDateTime.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(OffsetDateTime.class, Type.TIMESTAMP);
        JAVA_TO_TYPE_MAP.put(ZonedDateTime.class, Type.TIMESTAMP);
        TYPE_TO_JAVA_MAP.put(Type.NUMERIC, BigDecimal.class);
        TYPE_TO_JAVA_MAP.put(Type.BIGINT, BigInteger.class);
        TYPE_TO_JAVA_MAP.put(Type.BOOLEAN, Boolean.class);
        TYPE_TO_JAVA_MAP.put(Type.TINYINT, Byte.class);
        TYPE_TO_JAVA_MAP.put(Type.SMALLINT, Short.class);
        TYPE_TO_JAVA_MAP.put(Type.VARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.BIGINT, Long.class);
        TYPE_TO_JAVA_MAP.put(Type.BINARY, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.BIT, Boolean.class);
        TYPE_TO_JAVA_MAP.put(Type.BLOB, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.CHAR, Character.class);
        TYPE_TO_JAVA_MAP.put(Type.CLOB, Clob.class);
        TYPE_TO_JAVA_MAP.put(Type.DECIMAL, BigDecimal.class);
        TYPE_TO_JAVA_MAP.put(Type.DOUBLE, Double.class);
        TYPE_TO_JAVA_MAP.put(Type.FLOAT, Float.class);
        TYPE_TO_JAVA_MAP.put(Type.INTEGER, Integer.class);
        TYPE_TO_JAVA_MAP.put(Type.JAVA_OBJECT, Object.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGNVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGVARBINARY, String.class);
        TYPE_TO_JAVA_MAP.put(Type.LONGVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.NCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.NCLOB, Clob.class);
        TYPE_TO_JAVA_MAP.put(Type.NVARCHAR, String.class);
        TYPE_TO_JAVA_MAP.put(Type.UNKNOW, Object.class);
        TYPE_TO_JAVA_MAP.put(Type.REAL, Float.class);
        TYPE_TO_JAVA_MAP.put(Type.VARBINARY, Blob.class);
        TYPE_TO_JAVA_MAP.put(Type.DATE, java.util.Date.class);
        TYPE_TO_JAVA_MAP.put(Type.TIME, Time.class);
        TYPE_TO_JAVA_MAP.put(Type.TIMESTAMP, Timestamp.class);
    }
}

