/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;

public class IdentityIdGenerator
implements IdGenerator {
    public static final IdentityIdGenerator INSTANCE = new IdentityIdGenerator();

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.IDENTITY;
    }

    @Override
    public String getIdGenName() {
        return "IDENTITY";
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public Object getNextID(NormalJdbcTool jdbc, Dialect dialect, Type dataType) {
        if (!dialect.ddlFeatures.getSupportsIdentityColumns().booleanValue()) {
            throw new DialectException("Dialect '" + dialect + "' does not support identity type");
        }
        String sql = null;
        sql = Type.BIGINT.equals((Object)dataType) ? dialect.ddlFeatures.getIdentitySelectStringBigINT() : dialect.ddlFeatures.getIdentitySelectString();
        if (StrUtils.isEmpty(sql) || "NOT_SUPPORT".equals(sql)) {
            throw new DialectException("Dialect '" + dialect + "' does not support identity type");
        }
        return jdbc.nQueryForObject(sql, new Object[0]);
    }

    @Override
    public IdGenerator newCopy() {
        return INSTANCE;
    }
}

