/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DebugUtils;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.UUIDAnyGenerator;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.util.Iterator;
import java.util.List;

public class ColumnModel {
    private String columnName;
    private TableModel tableModel;
    private Type columnType;
    private Boolean pkey = false;
    private Boolean nullable = true;
    private String check;
    private String defaultValue;
    private String tail;
    private String comment;
    private GenerationType idGenerationType;
    private String idGeneratorName;
    private Object converterClassOrName;
    private String entityField;
    private Integer length = 250;
    private Integer precision = 0;
    private Integer scale = 0;
    private Boolean insertable = true;
    private Boolean updatable = true;
    private Boolean transientable = false;
    private String[] shardTable = null;
    private String[] shardDatabase = null;
    private Object value;
    private Boolean valueExist = false;

    public ColumnModel(String columnName) {
        if (StrUtils.isEmpty(columnName)) {
            DialectException.throwEX("columnName is not allowed empty");
        }
        this.columnName = columnName;
    }

    public ColumnModel notNull() {
        this.nullable = false;
        return this;
    }

    public ColumnModel check(String check) {
        this.check = check;
        return this;
    }

    public ColumnModel newCopy() {
        ColumnModel col = new ColumnModel(this.columnName);
        col.columnType = this.columnType;
        col.pkey = (boolean)this.pkey;
        col.nullable = this.nullable;
        col.check = this.check;
        col.defaultValue = this.defaultValue;
        col.tail = this.tail;
        col.comment = this.comment;
        col.entityField = this.entityField;
        col.length = this.length;
        col.precision = this.precision;
        col.scale = this.scale;
        col.insertable = this.insertable;
        col.updatable = this.updatable;
        col.transientable = this.transientable;
        col.idGeneratorName = this.idGeneratorName;
        col.idGenerationType = this.idGenerationType;
        col.shardTable = this.shardTable;
        col.shardDatabase = this.shardDatabase;
        col.converterClassOrName = this.converterClassOrName;
        col.value = this.value;
        col.valueExist = this.valueExist;
        return col;
    }

    public ColumnModel singleIndex(String indexName) {
        this.makeSureTableModelExist();
        DialectException.assureNotEmpty(indexName, "indexName can not be empty");
        this.tableModel.index(indexName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleIndex() {
        this.makeSureTableModelExist();
        this.tableModel.index().columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique(String uniqueName) {
        this.makeSureTableModelExist();
        DialectException.assureNotEmpty(uniqueName, "indexName can not be empty");
        this.tableModel.unique(uniqueName).columns(this.getColumnName());
        return this;
    }

    public ColumnModel singleUnique() {
        this.makeSureTableModelExist();
        this.tableModel.unique().columns(this.getColumnName());
        return this;
    }

    private void makeSureTableModelExist() {
        DialectException.assureNotNull(this.tableModel, "ColumnModel should belong to a TableModel, please call tableModel.column() method first.");
    }

    public ColumnModel defaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public ColumnModel comment(String comment) {
        this.comment = comment;
        return this;
    }

    public ColumnModel pkey() {
        this.pkey = true;
        return this;
    }

    public ColumnModel shardTable(String ... shardTable) {
        this.shardTable = shardTable;
        return this;
    }

    public ColumnModel shardDatabase(String ... shardDatabase) {
        this.shardDatabase = shardDatabase;
        return this;
    }

    public ColumnModel id() {
        this.pkey = true;
        return this;
    }

    public FKeyModel singleFKey(String ... refTableAndColumns) {
        this.makeSureTableModelExist();
        if (refTableAndColumns == null || refTableAndColumns.length > 2) {
            throw new DialectException("singleFKey() first parameter should be table name, second parameter(optional) should be column name");
        }
        return this.tableModel.fkey().columns(this.columnName).refs(refTableAndColumns);
    }

    public IdGenerator getIdGenerator() {
        this.makeSureTableModelExist();
        return this.tableModel.getIdGenerator(this.idGenerationType, this.idGeneratorName);
    }

    public ColumnModel identityId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.IDENTITY;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid25() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID25;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid32() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID32;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuid36() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID36;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel snowflake() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.SNOWFLAKE;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel uuidAny(String name, Integer length) {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.UUID_ANY;
        this.idGeneratorName = name;
        if (this.tableModel.getIdGenerator(GenerationType.UUID_ANY, this.idGeneratorName) == null) {
            this.tableModel.getIdGenerators().add(new UUIDAnyGenerator(name, length));
        }
        return this;
    }

    public ColumnModel timeStampId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.TIMESTAMP;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel autoId() {
        this.makeSureTableModelExist();
        this.idGenerationType = GenerationType.AUTO;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel sortedUUID(String name, Integer sortedLength, Integer uuidLength) {
        this.makeSureTableModelExist();
        this.tableModel.sortedUUIDGenerator(name, sortedLength, uuidLength);
        this.idGenerationType = GenerationType.SORTED_UUID;
        this.idGeneratorName = null;
        return this;
    }

    public ColumnModel sequenceGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.makeSureTableModelExist();
        this.tableModel.sequenceGenerator(name, sequenceName, initialValue, allocationSize);
        this.idGenerationType = GenerationType.SEQUENCE;
        this.idGeneratorName = name;
        return this;
    }

    public ColumnModel idGenerator(String idGeneratorName) {
        this.makeSureTableModelExist();
        this.idGenerationType = null;
        this.idGeneratorName = idGeneratorName;
        return this;
    }

    public ColumnModel tableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.makeSureTableModelExist();
        this.tableModel.tableGenerator(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize);
        this.idGenerationType = GenerationType.TABLE;
        this.idGeneratorName = name;
        return this;
    }

    public ColumnModel tail(String tail) {
        this.tail = tail;
        return this;
    }

    public ColumnModel entityField(String entityFieldName) {
        DialectException.assureNotEmpty(entityFieldName, "entityFieldName can not be empty");
        this.entityField = entityFieldName;
        if (this.tableModel != null) {
            List<ColumnModel> oldColumns = this.tableModel.getColumns();
            Iterator<ColumnModel> columnIter = oldColumns.iterator();
            while (columnIter.hasNext()) {
                ColumnModel column = columnIter.next();
                if (!entityFieldName.equals(column.getEntityField()) || this.getColumnName().equals(column.getColumnName())) continue;
                columnIter.remove();
            }
        }
        return this;
    }

    public ColumnModel insertable(Boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public ColumnModel updatable(Boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public String getDebugInfo() {
        return DebugUtils.getColumnModelDebugInfo(this);
    }

    public void checkReadOnly() {
        if (this.tableModel != null && this.tableModel.getReadOnly().booleanValue()) {
            throw new DialectException("TableModel '" + this.tableModel.getTableName() + "' is readOnly, can not be modified.");
        }
    }

    public ColumnModel LONG() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BOOLEAN() {
        this.columnType = Type.BOOLEAN;
        return this;
    }

    public ColumnModel DOUBLE() {
        this.columnType = Type.DOUBLE;
        return this;
    }

    public ColumnModel INTEGER() {
        this.columnType = Type.INTEGER;
        return this;
    }

    public ColumnModel SHORT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel DATE() {
        this.columnType = Type.DATE;
        return this;
    }

    public ColumnModel TIME() {
        this.columnType = Type.TIME;
        return this;
    }

    public ColumnModel TIMESTAMP() {
        this.columnType = Type.TIMESTAMP;
        return this;
    }

    public ColumnModel BIGINT() {
        this.columnType = Type.BIGINT;
        return this;
    }

    public ColumnModel BIT() {
        this.columnType = Type.BIT;
        return this;
    }

    public ColumnModel JAVA_OBJECT() {
        this.columnType = Type.JAVA_OBJECT;
        return this;
    }

    public ColumnModel NCLOB() {
        this.columnType = Type.NCLOB;
        return this;
    }

    public ColumnModel REAL() {
        this.columnType = Type.REAL;
        return this;
    }

    public ColumnModel SMALLINT() {
        this.columnType = Type.SMALLINT;
        return this;
    }

    public ColumnModel TINYINT() {
        this.columnType = Type.TINYINT;
        return this;
    }

    public ColumnModel LONGNVARCHAR(Integer length) {
        this.columnType = Type.LONGNVARCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel NCHAR(Integer length) {
        this.columnType = Type.NCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel NVARCHAR(Integer length) {
        this.columnType = Type.NVARCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel STRING(Integer length) {
        this.columnType = Type.VARCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel VARCHAR(Integer length) {
        this.columnType = Type.VARCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel FLOAT() {
        this.columnType = Type.FLOAT;
        return this;
    }

    public ColumnModel FLOAT(Integer precision) {
        this.columnType = Type.FLOAT;
        this.precision = precision;
        return this;
    }

    public ColumnModel BIGDECIMAL() {
        this.columnType = Type.NUMERIC;
        return this;
    }

    public ColumnModel BIGDECIMAL(Integer digiLength) {
        this.columnType = Type.NUMERIC;
        this.length = digiLength;
        return this;
    }

    public ColumnModel BIGDECIMAL(Integer precision, Integer scale) {
        this.columnType = Type.NUMERIC;
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public ColumnModel DECIMAL() {
        this.columnType = Type.DECIMAL;
        return this;
    }

    public ColumnModel DECIMAL(Integer precision, Integer scale) {
        this.columnType = Type.DECIMAL;
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public ColumnModel BINARY() {
        this.columnType = Type.BINARY;
        return this;
    }

    public ColumnModel BINARY(Integer length) {
        this.columnType = Type.BINARY;
        this.length = length;
        return this;
    }

    public ColumnModel BLOB() {
        this.columnType = Type.BLOB;
        return this;
    }

    public ColumnModel BLOB(Integer length) {
        this.columnType = Type.BLOB;
        this.length = length;
        return this;
    }

    public ColumnModel CHAR() {
        this.columnType = Type.CHAR;
        return this;
    }

    public ColumnModel CHAR(Integer length) {
        this.columnType = Type.CHAR;
        this.length = length;
        return this;
    }

    public ColumnModel CLOB() {
        this.columnType = Type.CLOB;
        return this;
    }

    public ColumnModel CLOB(Integer length) {
        this.columnType = Type.CLOB;
        this.length = length;
        return this;
    }

    public ColumnModel LONGVARBINARY() {
        this.columnType = Type.LONGVARBINARY;
        return this;
    }

    public ColumnModel LONGVARBINARY(Integer length) {
        this.columnType = Type.LONGVARBINARY;
        this.length = length;
        return this;
    }

    public ColumnModel LONGVARCHAR() {
        this.columnType = Type.LONGVARCHAR;
        return this;
    }

    public ColumnModel LONGVARCHAR(Integer length) {
        this.columnType = Type.LONGVARCHAR;
        this.length = length;
        return this;
    }

    public ColumnModel NUMERIC() {
        this.columnType = Type.NUMERIC;
        return this;
    }

    public ColumnModel NUMERIC(Integer digiLength) {
        this.columnType = Type.NUMERIC;
        this.length = digiLength;
        return this;
    }

    public ColumnModel NUMERIC(Integer precision, Integer scale) {
        this.columnType = Type.NUMERIC;
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public ColumnModel VARBINARY() {
        this.columnType = Type.VARBINARY;
        return this;
    }

    public ColumnModel VARBINARY(Integer length) {
        this.columnType = Type.VARBINARY;
        this.length = length;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public Type getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Type columnType) {
        this.columnType = columnType;
    }

    public Boolean getPkey() {
        return this.pkey;
    }

    public void setPkey(Boolean pkey) {
        this.pkey = pkey;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public GenerationType getIdGenerationType() {
        return this.idGenerationType;
    }

    public void setIdGenerationType(GenerationType idGenerationType) {
        this.idGenerationType = idGenerationType;
    }

    public String getIdGeneratorName() {
        return this.idGeneratorName;
    }

    public void setIdGeneratorName(String idGeneratorName) {
        this.idGeneratorName = idGeneratorName;
    }

    public String getTail() {
        return this.tail;
    }

    public void setTail(String tail) {
        this.tail = tail;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEntityField() {
        return this.entityField;
    }

    public void setEntityField(String entityField) {
        this.entityField = entityField;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public Boolean getInsertable() {
        return this.insertable;
    }

    public void setInsertable(Boolean insertable) {
        this.insertable = insertable;
    }

    public Boolean getUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(Boolean updatable) {
        this.updatable = updatable;
    }

    public Boolean getTransientable() {
        return this.transientable;
    }

    public void setTransientable(Boolean transientable) {
        this.transientable = transientable;
    }

    public String[] getShardTable() {
        return this.shardTable;
    }

    public void setShardTable(String[] shardTable) {
        this.shardTable = shardTable;
    }

    public String[] getShardDatabase() {
        return this.shardDatabase;
    }

    public void setShardDatabase(String[] shardDatabase) {
        this.shardDatabase = shardDatabase;
    }

    public Object getConverterClassOrName() {
        return this.converterClassOrName;
    }

    public void setConverterClassOrName(Object converterClassOrName) {
        this.converterClassOrName = converterClassOrName;
    }

    public Object getValue() {
        return this.value;
    }

    public ColumnModel setValue(Object value) {
        this.value = value;
        this.valueExist = true;
        return this;
    }

    public Boolean getValueExist() {
        return this.valueExist;
    }

    public ColumnModel setValueExist(Boolean valueExist) {
        this.valueExist = valueExist;
        return this;
    }
}

