/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DebugUtils;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.AutoIdGenerator;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.id.IdentityIdGenerator;
import com.github.drinkjava2.jdialects.id.SequenceIdGenerator;
import com.github.drinkjava2.jdialects.id.SnowflakeGenerator;
import com.github.drinkjava2.jdialects.id.SortedUUIDGenerator;
import com.github.drinkjava2.jdialects.id.TableIdGenerator;
import com.github.drinkjava2.jdialects.id.TimeStampIdGenerator;
import com.github.drinkjava2.jdialects.id.UUID25Generator;
import com.github.drinkjava2.jdialects.id.UUID32Generator;
import com.github.drinkjava2.jdialects.id.UUID36Generator;
import com.github.drinkjava2.jdialects.id.UUIDAnyGenerator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.IndexModel;
import com.github.drinkjava2.jdialects.model.UniqueModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TableModel {
    private String tableName;
    private String check;
    private String comment;
    private String engineTail;
    private List<ColumnModel> columns = new ArrayList<ColumnModel>();
    private List<IdGenerator> idGenerators;
    private List<FKeyModel> fkeyConstraints;
    private List<IndexModel> indexConsts;
    private List<UniqueModel> uniqueConsts;
    private Class<?> entityClass;
    private Boolean readOnly = false;

    public TableModel() {
    }

    public TableModel(String tableName) {
        this.tableName = tableName;
    }

    public TableModel newCopy() {
        TableModel tb = new TableModel();
        tb.tableName = this.tableName;
        tb.check = this.check;
        tb.comment = this.comment;
        tb.engineTail = this.engineTail;
        tb.entityClass = this.entityClass;
        if (!this.columns.isEmpty()) {
            for (ColumnModel columnModel : this.columns) {
                ColumnModel newItem = columnModel.newCopy();
                newItem.setTableModel(tb);
                tb.columns.add(newItem);
            }
        }
        if (this.idGenerators != null && !this.idGenerators.isEmpty()) {
            for (IdGenerator idGenerator : this.idGenerators) {
                tb.getIdGenerators().add(idGenerator.newCopy());
            }
        }
        if (this.fkeyConstraints != null && !this.fkeyConstraints.isEmpty()) {
            for (FKeyModel fKeyModel : this.fkeyConstraints) {
                tb.getFkeyConstraints().add(fKeyModel.newCopy());
            }
        }
        if (this.indexConsts != null && !this.indexConsts.isEmpty()) {
            for (IndexModel indexModel : this.indexConsts) {
                tb.getIndexConsts().add(indexModel.newCopy());
            }
        }
        if (this.uniqueConsts != null && !this.uniqueConsts.isEmpty()) {
            for (UniqueModel uniqueModel : this.uniqueConsts) {
                tb.getUniqueConsts().add(uniqueModel.newCopy());
            }
        }
        return tb;
    }

    public void tableGenerator(String name, String tableName, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.checkReadOnly();
        this.addGenerator(new TableIdGenerator(name, tableName, pkColumnName, valueColumnName, pkColumnValue, initialValue, allocationSize));
    }

    public void uuidAny(String name, Integer length) {
        this.checkReadOnly();
        this.addGenerator(new UUIDAnyGenerator(name, length));
    }

    public void addGenerator(IdGenerator generator) {
        this.checkReadOnly();
        DialectException.assureNotNull(generator, new String[0]);
        DialectException.assureNotNull((Object)generator.getGenerationType(), new String[0]);
        DialectException.assureNotEmpty(generator.getIdGenName(), "IdGenerator name can not be empty");
        this.getIdGenerators().add(generator);
    }

    public void sequenceGenerator(String name, String sequenceName, Integer initialValue, Integer allocationSize) {
        this.checkReadOnly();
        this.addGenerator(new SequenceIdGenerator(name, sequenceName, initialValue, allocationSize));
    }

    public void sortedUUIDGenerator(String name, Integer sortedLength, Integer uuidLength) {
        this.checkReadOnly();
        DialectException.assureNotNull(name, new String[0]);
        if (this.getIdGenerator(GenerationType.SORTED_UUID, name) != null) {
            throw new DialectException("Duplicated sortedUUIDGenerator name '" + name + "'");
        }
        this.idGenerators.add(new SortedUUIDGenerator(name, sortedLength, uuidLength));
    }

    public TableModel check(String check) {
        this.checkReadOnly();
        this.check = check;
        return this;
    }

    public TableModel comment(String comment) {
        this.checkReadOnly();
        this.comment = comment;
        return this;
    }

    public TableModel addColumn(ColumnModel column) {
        this.checkReadOnly();
        DialectException.assureNotNull(column, new String[0]);
        DialectException.assureNotEmpty(column.getColumnName(), "Column's columnName can not be empty");
        column.setTableModel(this);
        this.columns.add(column);
        return this;
    }

    public static void sortColumns(List<ColumnModel> lst) {
        if (lst == null || lst.isEmpty()) {
            return;
        }
        Collections.sort(lst, new Comparator<ColumnModel>(){

            @Override
            public int compare(ColumnModel a, ColumnModel b) {
                if (a == null || b == null || a.getColumnName() == null) {
                    return -1;
                }
                return a.getColumnName().compareTo(b.getColumnName());
            }
        });
    }

    public TableModel removeColumn(String columnName) {
        this.checkReadOnly();
        List<ColumnModel> oldColumns = this.getColumns();
        Iterator<ColumnModel> columnIter = oldColumns.iterator();
        while (columnIter.hasNext()) {
            if (!columnIter.next().getColumnName().equalsIgnoreCase(columnName)) continue;
            columnIter.remove();
        }
        return this;
    }

    public TableModel removeFKey(String fkeyName) {
        this.checkReadOnly();
        List<FKeyModel> fkeys = this.getFkeyConstraints();
        Iterator<FKeyModel> fkeyIter = fkeys.iterator();
        while (fkeyIter.hasNext()) {
            if (!fkeyIter.next().getFkeyName().equalsIgnoreCase(fkeyName)) continue;
            fkeyIter.remove();
        }
        return this;
    }

    public ColumnModel column(String columnName) {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getColumnName() != null && columnModel.getColumnName().equalsIgnoreCase(columnName)) {
                return columnModel;
            }
            if (columnModel.getEntityField() == null || !columnModel.getEntityField().equalsIgnoreCase(columnName)) continue;
            return columnModel;
        }
        return this.addColumn(columnName);
    }

    public ColumnModel addColumn(String columnName) {
        this.checkReadOnly();
        DialectException.assureNotEmpty(columnName, "columnName can not be empty");
        for (ColumnModel columnModel : this.columns) {
            if (!columnName.equalsIgnoreCase(columnModel.getColumnName())) continue;
            throw new DialectException("ColumnModel name '" + columnName + "' already existed");
        }
        ColumnModel column = new ColumnModel(columnName);
        this.addColumn(column);
        return column;
    }

    public ColumnModel getColumn(String colOrFieldName) {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getColumnName() != null && columnModel.getColumnName().equalsIgnoreCase(colOrFieldName)) {
                return columnModel;
            }
            if (columnModel.getEntityField() == null || !columnModel.getEntityField().equalsIgnoreCase(colOrFieldName)) continue;
            return columnModel;
        }
        return null;
    }

    public ColumnModel getColumnByColName(String colName) {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getColumnName() == null || !columnModel.getColumnName().equalsIgnoreCase(colName)) continue;
            return columnModel;
        }
        return null;
    }

    public ColumnModel getColumnByFieldName(String fieldName) {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getEntityField() == null || !columnModel.getEntityField().equalsIgnoreCase(fieldName)) continue;
            return columnModel;
        }
        return null;
    }

    public ColumnModel getShardTableColumn() {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getShardTable() == null) continue;
            return columnModel;
        }
        return null;
    }

    public ColumnModel getShardDatabaseColumn() {
        for (ColumnModel columnModel : this.columns) {
            if (columnModel.getShardDatabase() == null) continue;
            return columnModel;
        }
        return null;
    }

    public FKeyModel fkey() {
        this.checkReadOnly();
        FKeyModel fkey = new FKeyModel();
        fkey.setTableName(this.tableName);
        fkey.setTableModel(this);
        this.getFkeyConstraints().add(fkey);
        return fkey;
    }

    public FKeyModel fkey(String fkeyName) {
        this.checkReadOnly();
        FKeyModel fkey = new FKeyModel();
        fkey.setTableName(this.tableName);
        fkey.setFkeyName(fkeyName);
        fkey.setTableModel(this);
        this.getFkeyConstraints().add(fkey);
        return fkey;
    }

    public FKeyModel getFkey(String fkeyName) {
        if (this.fkeyConstraints == null) {
            return null;
        }
        for (FKeyModel fkey : this.fkeyConstraints) {
            if (StrUtils.isEmpty(fkeyName) || !fkeyName.equalsIgnoreCase(fkey.getFkeyName())) continue;
            return fkey;
        }
        return null;
    }

    public IndexModel index() {
        this.checkReadOnly();
        IndexModel index = new IndexModel();
        index.setTableModel(this);
        this.getIndexConsts().add(index);
        return index;
    }

    public IndexModel index(String indexName) {
        this.checkReadOnly();
        IndexModel index = new IndexModel();
        index.setName(indexName);
        index.setTableModel(this);
        this.getIndexConsts().add(index);
        return index;
    }

    public UniqueModel unique() {
        this.checkReadOnly();
        UniqueModel unique = new UniqueModel();
        unique.setTableModel(this);
        this.getUniqueConsts().add(unique);
        return unique;
    }

    public UniqueModel unique(String uniqueName) {
        this.checkReadOnly();
        UniqueModel unique = new UniqueModel();
        unique.setName(uniqueName);
        unique.setTableModel(this);
        this.getUniqueConsts().add(unique);
        return unique;
    }

    public TableModel engineTail(String engineTail) {
        this.checkReadOnly();
        this.engineTail = engineTail;
        return this;
    }

    public IdGenerator getIdGenerator(GenerationType generationType, String name) {
        return TableModel.getIdGenerator(generationType, name, this.getIdGenerators());
    }

    public IdGenerator getIdGenerator(GenerationType generationType) {
        return TableModel.getIdGeneratorByType(generationType);
    }

    public IdGenerator getIdGenerator(String name) {
        return TableModel.getIdGenerator(null, name, this.getIdGenerators());
    }

    public static IdGenerator getIdGeneratorByType(GenerationType generationType) {
        if (generationType == null) {
            return null;
        }
        switch (generationType) {
            case IDENTITY: {
                return IdentityIdGenerator.INSTANCE;
            }
            case AUTO: {
                return AutoIdGenerator.INSTANCE;
            }
            case UUID25: {
                return UUID25Generator.INSTANCE;
            }
            case UUID32: {
                return UUID32Generator.INSTANCE;
            }
            case UUID36: {
                return UUID36Generator.INSTANCE;
            }
            case TIMESTAMP: {
                return TimeStampIdGenerator.INSTANCE;
            }
            case SNOWFLAKE: {
                return SnowflakeGenerator.INSTANCE;
            }
        }
        return null;
    }

    public static IdGenerator getIdGenerator(GenerationType generationType, String name, List<IdGenerator> idGeneratorList) {
        IdGenerator idGen = TableModel.getIdGeneratorByType(generationType);
        if (idGen != null) {
            return idGen;
        }
        if (StrUtils.isEmpty(name)) {
            return null;
        }
        for (IdGenerator idGenerator : idGeneratorList) {
            if (generationType != null && name.equalsIgnoreCase(idGenerator.getIdGenName())) {
                return idGenerator;
            }
            if (generationType != null && !GenerationType.OTHER.equals((Object)generationType) || !name.equalsIgnoreCase(idGenerator.getIdGenName())) continue;
            return idGenerator;
        }
        return null;
    }

    public int getPKeyCount() {
        int pkeyCount = 0;
        for (ColumnModel col : this.columns) {
            if (!col.getPkey().booleanValue() || col.getTransientable().booleanValue()) continue;
            ++pkeyCount;
        }
        return pkeyCount;
    }

    public ColumnModel getFirstPKeyColumn() {
        for (ColumnModel col : this.columns) {
            if (!col.getPkey().booleanValue() || col.getTransientable().booleanValue()) continue;
            return col;
        }
        return null;
    }

    public List<ColumnModel> getPKeyColumns() {
        ArrayList<ColumnModel> pkeyCols = new ArrayList<ColumnModel>();
        for (ColumnModel col : this.columns) {
            if (!col.getPkey().booleanValue() || col.getTransientable().booleanValue()) continue;
            pkeyCols.add(col);
        }
        return pkeyCols;
    }

    public String getDebugInfo() {
        return DebugUtils.getTableModelDebugInfo(this);
    }

    private void checkReadOnly() {
        if (this.readOnly.booleanValue()) {
            throw new DialectException("TableModel '" + this.tableName + "' is readOnly, can not be modified.");
        }
    }

    protected void getAndSetters____________________________() {
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.checkReadOnly();
        this.tableName = tableName;
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.checkReadOnly();
        this.check = check;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.checkReadOnly();
        this.comment = comment;
    }

    public List<ColumnModel> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnModel> columns) {
        this.checkReadOnly();
        this.columns = columns;
    }

    public List<FKeyModel> getFkeyConstraints() {
        if (this.fkeyConstraints == null) {
            this.fkeyConstraints = new ArrayList<FKeyModel>();
        }
        return this.fkeyConstraints;
    }

    public void setFkeyConstraints(List<FKeyModel> fkeyConstraints) {
        this.checkReadOnly();
        this.fkeyConstraints = fkeyConstraints;
    }

    public String getEngineTail() {
        return this.engineTail;
    }

    public void setEngineTail(String engineTail) {
        this.checkReadOnly();
        this.engineTail = engineTail;
    }

    public List<IndexModel> getIndexConsts() {
        if (this.indexConsts == null) {
            this.indexConsts = new ArrayList<IndexModel>();
        }
        return this.indexConsts;
    }

    public void setIndexConsts(List<IndexModel> indexConsts) {
        this.checkReadOnly();
        this.indexConsts = indexConsts;
    }

    public List<UniqueModel> getUniqueConsts() {
        if (this.uniqueConsts == null) {
            this.uniqueConsts = new ArrayList<UniqueModel>();
        }
        return this.uniqueConsts;
    }

    public void setUniqueConsts(List<UniqueModel> uniqueConsts) {
        this.checkReadOnly();
        this.uniqueConsts = uniqueConsts;
    }

    public List<IdGenerator> getIdGenerators() {
        if (this.idGenerators == null) {
            this.idGenerators = new ArrayList<IdGenerator>();
        }
        return this.idGenerators;
    }

    public void setIdGenerators(List<IdGenerator> idGenerators) {
        this.checkReadOnly();
        this.idGenerators = idGenerators;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.checkReadOnly();
        this.entityClass = entityClass;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }
}

