/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jlogs;

import com.github.drinkjava2.jlogs.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ConsoleLog
implements Log {
    public static final int OFF = 5;
    public static final int ERROR = 4;
    public static final int WARNING = 3;
    public static final int INFO = 2;
    public static final int DEBUG = 1;
    Class<?> clazz;
    private static int logLevel = 2;
    private static boolean logHead = false;

    public ConsoleLog(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        ConsoleLog.logLevel = logLevel;
    }

    public static boolean isLogHead() {
        return logHead;
    }

    public static void setLogHead(boolean logHead) {
        ConsoleLog.logHead = logHead;
    }

    private String logheadStr(String method) {
        return logHead ? this.clazz.getSimpleName() + " " + method + ": " : "";
    }

    @Override
    public void info(String msg) {
        if (logLevel <= 2) {
            System.out.println(this.logheadStr("info") + msg);
        }
    }

    @Override
    public void warn(String msg) {
        if (logLevel <= 3) {
            System.out.println(this.logheadStr("warn") + msg);
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (logLevel <= 3) {
            System.out.println(this.logheadStr("warn") + msg + ConsoleLog.getStackTrace(t));
        }
    }

    @Override
    public void error(String msg) {
        if (logLevel <= 4) {
            System.out.println(this.logheadStr("error") + msg);
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (logLevel <= 3) {
            System.out.println(this.logheadStr("error") + msg + ConsoleLog.getStackTrace(t));
        }
    }

    @Override
    public void debug(String msg) {
        if (logLevel <= 1) {
            System.out.println(this.logheadStr("info") + msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }
}

