/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.jbeanbox.NameMatchUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;

public enum ClassScanner {

    private static final Pattern ANONYMOUS_INNER_CLASS_PATTERN = Pattern.compile("^[\\s\\S]*\\${1}\\d+\\.class$");

    public static List<Class> scanPackages(String ... scanBasePackages) {
        LinkedList<Class> classList = new LinkedList<Class>();
        if (scanBasePackages.length == 0) {
            return classList;
        }
        for (String pkg : scanBasePackages) {
            if (pkg == null || pkg.length() == 0) continue;
            classList.addAll(ClassScanner.scanOnePackage(pkg));
        }
        return classList;
    }

    public static List<Class> scanByAnno(Class<? extends Annotation> anno, String ... scanBasePackages) {
        List<Class> classList = ClassScanner.scanPackages(scanBasePackages);
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clz : classList) {
            Annotation clzAnno = clz.getAnnotation(anno);
            if (clzAnno == null) continue;
            result.add(clz);
        }
        return result;
    }

    public static List<Class> scanByName(String nameSimpleReg, String ... scanBasePackages) {
        List<Class> classList = ClassScanner.scanPackages(scanBasePackages);
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clz : classList) {
            if (!NameMatchUtil.nameMatch(nameSimpleReg, clz.getName())) continue;
            result.add(clz);
        }
        return result;
    }

    private static List<Class> scanOnePackage(String pkg) {
        LinkedList<Class> classList = new LinkedList();
        try {
            String pathName = ClassScanner.package2Path(pkg);
            Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(pathName);
            classList = ClassScanner.scanUrls(pkg, urls);
        }
        catch (IOException e) {
            System.err.println("Warning: Can not scan package\uff1a" + pkg);
        }
        return classList;
    }

    private static List<Class> scanUrls(String pkg, Enumeration<URL> urls) throws IOException {
        LinkedList<Class> classList = new LinkedList<Class>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String protocol = url.getProtocol();
            if (ProtocolTypes.file.name().equals(protocol)) {
                String path = URLDecoder.decode(url.getFile(), "UTF-8");
                classList.addAll(ClassScanner.recursiveScan4Path(pkg, path));
                continue;
            }
            if (!ProtocolTypes.jar.name().equals(protocol)) continue;
            String jarPath = ClassScanner.getJarPathFormUrl(url);
            classList.addAll(ClassScanner.recursiveScan4Jar(pkg, jarPath));
        }
        return classList;
    }

    private static String getJarPathFormUrl(URL url) {
        String file = url.getFile();
        String jarRealPath = file.substring(0, file.lastIndexOf("!")).replaceFirst("file:", "");
        return jarRealPath;
    }

    private static List<Class> recursiveScan4Path(String pkg, String filePath) {
        File[] dirs;
        File[] classes;
        LinkedList<Class> classList = new LinkedList<Class>();
        File file = new File(filePath);
        if (!file.exists() || !file.isDirectory()) {
            return classList;
        }
        for (File child : classes = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File child) {
                return ClassScanner.isClass(child.getName());
            }
        })) {
            String className = ClassScanner.classFile2SimpleClass(pkg + "." + child.getName());
            try {
                Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
                classList.add(clz);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning: Can not load class:" + className);
            }
            catch (LinkageError e) {
                System.err.println("Warning: Can not load class:" + className);
            }
        }
        for (File child : dirs = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        })) {
            String childPackageName = pkg + "." + child.getName();
            String childPath = filePath + "/" + child.getName();
            classList.addAll(ClassScanner.recursiveScan4Path(childPackageName, childPath));
        }
        return classList;
    }

    private static List<Class> recursiveScan4Jar(String pkg, String jarPath) throws IOException {
        LinkedList<Class> classList = new LinkedList<Class>();
        JarInputStream jin = new JarInputStream(new FileInputStream(jarPath));
        JarEntry entry = jin.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            entry = jin.getNextJarEntry();
            if (!name.contains(ClassScanner.package2Path(pkg)) || !ClassScanner.isClass(name) || ClassScanner.isAnonymousInnerClass(name)) continue;
            String className = ClassScanner.classFile2SimpleClass(ClassScanner.path2Package(name));
            try {
                Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(className);
                classList.add(clz);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Warning: Can not load class:" + className);
            }
            catch (LinkageError e) {
                System.err.println("Warning: Can not load class:" + className);
            }
        }
        return classList;
    }

    private static String package2Path(String packageName) {
        return packageName.replace(".", "/");
    }

    private static String path2Package(String pathName) {
        return pathName.replaceAll("/", ".");
    }

    private static boolean isClass(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return fileName.endsWith(".class");
    }

    private static String classFile2SimpleClass(String classFileName) {
        return classFileName.replace(".class", "");
    }

    private static boolean isAnonymousInnerClass(String className) {
        return ANONYMOUS_INNER_CLASS_PATTERN.matcher(className).matches();
    }

    public static enum ProtocolTypes {
        http,
        https,
        file,
        jar;

    }
}

