/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.id;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.JdbcUtil;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.annotation.jpa.GenerationType;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import java.sql.Connection;

public class TableIdGenerator
implements IdGenerator {
    private String name;
    private String table;
    private String pkColumnName = "";
    private String valueColumnName = "";
    private String pkColumnValue = "";
    private Integer initialValue = 0;
    private Integer allocationSize = 50;

    public TableIdGenerator() {
    }

    public TableIdGenerator(String name, String table, String pkColumnName, String valueColumnName, String pkColumnValue, Integer initialValue, Integer allocationSize) {
        this.name = name;
        this.table = table;
        this.pkColumnName = pkColumnName;
        this.valueColumnName = valueColumnName;
        this.pkColumnValue = pkColumnValue;
        this.initialValue = initialValue;
        this.allocationSize = allocationSize;
    }

    @Override
    public IdGenerator newCopy() {
        return new TableIdGenerator(this.name, this.table, this.pkColumnName, this.valueColumnName, this.pkColumnValue, this.initialValue, this.allocationSize);
    }

    @Override
    public GenerationType getGenerationType() {
        return GenerationType.TIMESTAMP;
    }

    @Override
    public String getIdGenName() {
        return this.name;
    }

    @Override
    public Boolean dependOnAutoIdGenerator() {
        return false;
    }

    @Override
    public Object getNextID(Connection con, Dialect dialect, Type dataType) {
        int countOfRec = ((Number)JdbcUtil.qryOneObject(con, "select count(*) from " + this.table + " where " + this.pkColumnName + "=?", this.pkColumnValue)).intValue();
        if (countOfRec == 0) {
            JdbcUtil.execute(con, "insert into " + this.table + "( " + this.pkColumnName + "," + this.valueColumnName + " )  values(?,?)", this.pkColumnValue, this.initialValue);
            return this.initialValue;
        }
        JdbcUtil.execute(con, "update " + this.table + " set " + this.valueColumnName + "=" + this.valueColumnName + "+" + this.allocationSize + "  where " + this.pkColumnName + " =?", this.pkColumnValue);
        int last = ((Number)JdbcUtil.qryOneObject(con, "select " + this.valueColumnName + " from " + this.table + " where " + this.pkColumnName + "=?", this.pkColumnValue)).intValue();
        return last;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getPkColumnName() {
        return this.pkColumnName;
    }

    public void setPkColumnName(String pkColumnName) {
        this.pkColumnName = pkColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getPkColumnValue() {
        return this.pkColumnValue;
    }

    public void setPkColumnValue(String pkColumnValue) {
        this.pkColumnValue = pkColumnValue;
    }

    public Integer getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Integer initialValue) {
        this.initialValue = initialValue;
    }

    public Integer getAllocationSize() {
        return this.allocationSize;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.allocationSize = allocationSize;
    }
}

