/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPMInstaller {
    private static final String VERSION = "version";
    public static final String DEFAULT_NPM_DOWNLOAD_ROOT = "https://registry.npmjs.org/npm/-/";
    private static final Object LOCK = new Object();
    private String nodeVersion;
    private String npmVersion;
    private String npmDownloadRoot;
    private String userName;
    private String password;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    NPMInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public NPMInstaller setNodeVersion(String nodeVersion) {
        this.nodeVersion = nodeVersion;
        return this;
    }

    public NPMInstaller setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
        return this;
    }

    public NPMInstaller setNpmDownloadRoot(String npmDownloadRoot) {
        this.npmDownloadRoot = npmDownloadRoot;
        return this;
    }

    public NPMInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public NPMInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    private boolean npmProvided() throws InstallationException {
        if ("provided".equals(this.npmVersion)) {
            if (Integer.parseInt(this.nodeVersion.replace("v", "").split("[.]")[0]) < 4) {
                throw new InstallationException("NPM version is '" + this.npmVersion + "' but Node didn't include NPM prior to v4.0.0");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (this.npmDownloadRoot == null || this.npmDownloadRoot.isEmpty()) {
                this.npmDownloadRoot = DEFAULT_NPM_DOWNLOAD_ROOT;
            }
            if (!this.npmProvided() && !this.npmIsAlreadyInstalled()) {
                this.installNpm();
            }
            this.copyNpmScripts();
        }
    }

    private boolean npmIsAlreadyInstalled() {
        try {
            File npmPackageJson = new File(this.config.getInstallDirectory() + Utils.normalize("/node/node_modules/npm/package.json"));
            if (npmPackageJson.exists()) {
                HashMap data = (HashMap)new ObjectMapper().readValue(npmPackageJson, HashMap.class);
                if (data.containsKey(VERSION)) {
                    String foundNpmVersion = data.get(VERSION).toString();
                    if (foundNpmVersion.equals(this.npmVersion)) {
                        this.logger.info("NPM {} is already installed.", (Object)foundNpmVersion);
                        return true;
                    }
                    this.logger.info("NPM {} was installed, but we need version {}", (Object)foundNpmVersion, (Object)this.npmVersion);
                    return false;
                }
                this.logger.info("Could not read NPM version from package.json");
                return false;
            }
            return false;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read package.json", ex);
        }
    }

    private void installNpm() throws InstallationException {
        try {
            this.logger.info("Installing npm version {}", (Object)this.npmVersion);
            String downloadUrl = this.npmDownloadRoot + "npm-" + this.npmVersion + ".tgz";
            CacheDescriptor cacheDescriptor = new CacheDescriptor("npm", this.npmVersion, "tar.gz");
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            File installDirectory = this.getNodeInstallDirectory();
            File nodeModulesDirectory = new File(installDirectory, "node_modules");
            File oldNpmDirectory = new File(installDirectory, "npm");
            File npmDirectory = new File(nodeModulesDirectory, "npm");
            try {
                if (oldNpmDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)oldNpmDirectory);
                }
                FileUtils.deleteDirectory((File)npmDirectory);
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing NPM installation.");
            }
            File packageDirectory = new File(nodeModulesDirectory, "package");
            try {
                this.extractFile(archive, nodeModulesDirectory);
            }
            catch (ArchiveExtractionException e) {
                if (e.getCause() instanceof EOFException) {
                    this.logger.error("The archive file {} is corrupted and will be deleted. Please try the build again.", (Object)archive.getPath());
                    archive.delete();
                    if (packageDirectory.exists()) {
                        FileUtils.deleteDirectory((File)packageDirectory);
                    }
                }
                throw e;
            }
            if (packageDirectory.exists() && !npmDirectory.exists() && !packageDirectory.renameTo(npmDirectory)) {
                this.logger.warn("Cannot rename NPM directory, making a copy.");
                FileUtils.copyDirectory((File)packageDirectory, (File)npmDirectory);
            }
            this.logger.info("Installed npm locally.");
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download npm", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the npm archive", e);
        }
        catch (IOException e) {
            throw new InstallationException("Could not copy npm", e);
        }
    }

    private void copyNpmScripts() throws InstallationException {
        File installDirectory = this.getNodeInstallDirectory();
        File nodeModulesDirectory = new File(installDirectory, "node_modules");
        File npmDirectory = new File(nodeModulesDirectory, "npm");
        for (String script : Arrays.asList("npm", "npm.cmd")) {
            File copy;
            File scriptFile = new File(npmDirectory, "bin" + File.separator + script);
            if (!scriptFile.exists() || (copy = new File(installDirectory, script)).exists()) continue;
            try {
                FileUtils.copyFile((File)scriptFile, (File)copy);
            }
            catch (IOException e) {
                throw new InstallationException("Could not copy npm", e);
            }
            copy.setExecutable(true);
        }
    }

    private File getNodeInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), "/node");
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password);
    }
}

