/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xmind.core.CoreException;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.marker.IMarkerSheetBuilder;

public abstract class MarkerSheetBuilder
implements IMarkerSheetBuilder {
    public IMarkerSheet loadFromPath(String path, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        return this.loadFromFile(new File(path), resourceProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkerSheet loadFromFile(File file, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            IMarkerSheet iMarkerSheet = this.loadFromStream(stream, resourceProvider);
            return iMarkerSheet;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMarkerSheet loadFromURL(URL url, IMarkerResourceProvider resourceProvider) throws IOException, CoreException {
        InputStream stream = url.openStream();
        try {
            IMarkerSheet iMarkerSheet = this.loadFromStream(stream, resourceProvider);
            return iMarkerSheet;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }
}

