/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import org.xmind.core.Core;
import org.xmind.core.IWorkspace;
import org.xmind.core.util.FileUtils;

public class Workspace
implements IWorkspace {
    private static final String P_WORKSPACE = "org.xmind.core.workspace";
    private String workingDirectory = null;

    public String getAbsolutePath(String subPath) {
        if (subPath == null) {
            return null;
        }
        String wd = this.getWorkingDirectory();
        File f = new File(wd, subPath);
        return f.getAbsolutePath();
    }

    public String getWorkingDirectory() {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.getDefaultWorkingDirectory();
            System.setProperty(P_WORKSPACE, this.workingDirectory);
        }
        return this.workingDirectory;
    }

    private String getDefaultWorkingDirectory() {
        String homeDir = System.getProperty("user.home");
        if (homeDir != null) {
            return homeDir + "/Library/XMind/workspace-cathy/.xmind";
        }
        return "";
    }

    public void setWorkingDirectory(String path) {
        this.workingDirectory = path;
        System.setProperty(P_WORKSPACE, path);
    }

    public String getTempDir() {
        return this.getAbsolutePath("temp");
    }

    public String getTempDir(String subPath) {
        return FileUtils.ensureDirectory(new File(this.getTempDir(), subPath)).getAbsolutePath();
    }

    public String getTempFile(String fileName) {
        return FileUtils.ensureFileParent(new File(this.getTempDir(), fileName)).getAbsolutePath();
    }

    public File createTempFile(String subPath, String prefix, String suffix) {
        String fileName = prefix + Core.getIdFactory().createId() + suffix;
        File file = new File(this.getTempFile(subPath), fileName);
        while (file.exists()) {
            fileName = prefix + Core.getIdFactory().createId() + suffix;
            file = new File(this.getTempFile(subPath), fileName);
        }
        return FileUtils.ensureFileParent(file);
    }
}

