/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.EncryptionData;
import org.xmind.core.internal.dom.FileEntryImpl;
import org.xmind.core.util.DOMUtils;

public class EncryptionDataImpl
extends EncryptionData {
    private Element implementation;
    private FileEntryImpl entry;

    public EncryptionDataImpl(Element implementation, FileEntryImpl entry) {
        this.implementation = implementation;
        this.entry = entry;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.getImplementation();
        }
        return super.getAdapter(adapter);
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public int getIntAttribute(int defaultValue, String ... keyPath) {
        String value = this.getAttribute(keyPath);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public String getAttribute(String ... keys) {
        if (keys.length > 0) {
            Element ele = this.implementation;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (i == keys.length - 1) {
                    return DOMUtils.getAttribute(ele, key);
                }
                ele = DOMUtils.getFirstChildElementByTag(ele, key);
            }
        }
        return null;
    }

    public void setAttribute(String value, String ... keys) {
        if (keys.length > 0) {
            Element ele = this.implementation;
            for (int i = 0; i < keys.length; ++i) {
                Element ele2;
                String key = keys[i];
                if (i == keys.length - 1) {
                    DOMUtils.setAttribute(ele, key, value);
                }
                ele = (ele2 = DOMUtils.getFirstChildElementByTag(ele, key)) == null ? DOMUtils.createElement(ele, key) : ele2;
            }
        }
    }

    public String getChecksum() {
        return this.getAttribute("checksum");
    }

    public String getChecksumType() {
        return this.getAttribute("checksum-type");
    }

    public void setChecksum(String checksum) {
        this.setAttribute(checksum, "checksum");
    }

    public void setChecksumType(String checksumType) {
        this.setAttribute(checksumType, "checksum-type");
    }

    public IFileEntry getFileEntry() {
        return this.entry;
    }
}

